<?php defined('SYSPATH') or die('No direct script access.');

class Model_Translation extends ORM {

    protected $_table_name = 'translation';
    protected $_has_many = array('translation_detail' => array('foreign_key' => 'translation_id', 'far_key' => 'id'));
    protected $_sorting = array('label' => 'asc');

    public function get_all() {
        $list = array();
        $rows = $this->find_all();
        foreach($rows as $v) {
            foreach($v->translation_detail->find_all() as $detail) {
                $list[$v->label][$detail->language_id] = $detail->value;
            }
        }
        return $list;
    }

    public function get_all_by_language($language_id) {
        return $this->where('language_id' , '=', $language_id)->find_all();
    }

}

?>
