<?php defined('SYSPATH') or die('No direct script access.');

class Kohana_Translation {

    private $selected_language = NULL;
    private static $languages = array();

    public function __construct($language_id) {
        $languages = ORM::factory('Language')->find_all();
        foreach ($languages as $lang) {
            self::$languages[$lang->id] = $lang->short_name;
        }
        $translations_all = ORM::factory('Translation')->get_all();
        $this->selected_language = $language_id;
        Kohana_Session::instance()->set('translations', $translations_all);
    }

    public function __get($name) {
        $translations = Kohana_Session::instance()->get('translations');
        return (isset($translations[$name][$this->selected_language]) ? $translations[$name][$this->selected_language] : $name);
    }

    public static function get_full_list($type = self::TYPE_SHORT) {
        $translations_all = ORM::factory('Translation')->where('type', '=', $type)->find_all();
        $list = array();
        foreach($translations_all as $translation) {
            $list[$translation->id] = $translation->as_array();
            foreach($translation->translation_detail->find_all() as $detail) {
                $list[$translation->id]['values'][self::$languages[$detail->language_id]] = $detail['value'];
            }
        }
        return $list;
    }

    public static function get_all_as_selectbox_list($type = self::TYPE_SHORT, $language_id = NULL) {
        if ($language_id === NULL) {
            $language_id = Kohana_Session::instance()->get('application_language');
        }
        $translations_ids = ORM::factory('Translation')->where('type', '=', $type)->find_all()->as_array('id', 'id');
        $items = array();
        if (count($translations_ids)) {
            $details_model = new Model_Translation_Detail();
            $details_array = $details_model->where('translation_id', 'IN', $translations_ids)->where('language_id', '=', $language_id)->find_all();
            foreach ($details_array as $item) {
                $items[$item['translation_id']] = $item['value'];
            }
        }
        return $items;
    }

    public static function get_one($id) {
        $translations_all = ORM::factory('Translation')->find_all();
        foreach ($translations_all as $translation) {
            if ($translation->id == $id) {
                $item = array();
                foreach($translation->translation_detail->find_all() as $detail) {
                    $item[self::$languages[$detail->language_id]] = array(
                        'id' => $detail['id'],
                        'value' => $detail['value'],
                        'language_id' => $detail['language_id']
                    );
                }
                return $item;
            }
        }
    }

    public static function add_one($values, $type = self::TYPE_SHORT) {
        $values = array_merge($values, array('type'=>$type));
        $model = ORM::factory('Translation')->values($values)->save();
        foreach (self::$languages as $id_language => $language_name) {
            ORM::factory('Translation_Detail')->values(array(
                'language_id' => $id_language,
                'translation_id' => $model->id,
                'value' => ''
            ))->save();
        }
        return $model;
    }

}

?>
