<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Kohana_Sitemap extends Controller {

    private $limit = 40000;
    private $prefix = NULL;

    public function __construct(Kohana_Request $request) {
        parent::__construct($request);
        $this->prefix = Database::instance()->table_prefix();
    }

    public function action_index() {
        $anchor_count = DB::query(Database::SELECT, "Select count(id) as num From " . $this->prefix . "sitemap Where `show`=1 ")->execute()->get('num');
        $files = ceil ($anchor_count / $this->limit);
        if ($files > 1) {
            $view = View::factory('sitemap_index');
            $view->files = $files;
            ob_clean();
            header("Content-Type: text/xml");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo $view->render();
        } else {
            $this->action_details(1);
        }
        die;
    }

    public function action_details($id) {
        $offset = (($id - 1) * $this->limit);
        $view = View::factory('sitemap_details');
        $view->anchors = DB::query(
                Database::SELECT,
                "Select id, uri From " . $this->prefix . "sitemap " .
                "Where `show`=1 " .
                "Order By id ASC " .
                "Limit " . $offset . "," . $this->limit
                )->execute()->as_array('id', 'uri');
        ob_clean();
        header("Content-Type: text/xml");
        header("Pragma: no-cache");
        header("Expires: 0");
        echo $view->render();
        die;
    }

    public function action_robots() {
        $view = View::factory('sitemap_robots');
        $view->disallow = DB::query(Database::SELECT, "Select id, uri From " . Database::instance()->table_prefix() . "sitemap Where `show`=0")->execute()->as_array('id', 'uri');
        ob_clean();
        header('Content-type: text/plain');
        header("Pragma: no-cache");
        header("Expires: 0");
        echo $view->render();
        die;
    }

    public function action_gss() {
        ob_clean();
        header("Content-Type: text/xsl");
        header("Pragma: no-cache");
        header("Expires: 0");
        echo View::factory('sitemap_gss');
        die;
    }

}

?>
