<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Model_Simplerole_Factory
 *
 * @author luk32
 */
class Model_Simplerole_Factory {
    /**
     * MODEL_NAME Base classname this factory exists for.
     * @var string 
     */
    const MODEL_NAME = 'Model_Simplerole';
    /**
     * access driver string or array(); {@see ./driver.php|Model_Simplerole_Driver::factory()}
     * @property mixed
     */
    protected $driver = NULL;
    /**
     * name of the roles model
     * @property string
     */
    protected $model = NULL;
    /**
     * full class name of the roles model
     * @property string
     */
    protected $model_fullname = NULL;
    /**
     * @var Model_Simplerole_Driver
     */
    protected $driver_obj = NULL;

    public function __construct($model = 'Binary', $driver = 'File') {
        $this->driver = $driver;
        $this->model = $model;

        $this->model_fullname = self::MODEL_NAME . '_' . ucfirst($this->model);
        $this->driver_obj = $this->create_driver($driver);
    }

    public function get_roles() {
        return $this->driver_obj->get_roles();
    }

    /**
     * Function to check if a role with given condition for the specified field
     * exists in the database.
     * @param <mixed> $value
     * @param string $field property of the role to be checked
     * @param string $operator operator to be used for evaluation //unsupported - '==' is used
     * @return bool TRUE if such role exists
     */
    public function role_exists($value, $field = 'name') {
        return $this->driver_obj->role_exists($value);
    }

    /**
     * factory for creating role objects
     * @param string $name role name
     * @return Model_Simplerole created role object
     * @return NULL if driver cannot find the specified rolename
     */
    public function get_role($name) {
        /**
         * @var Model_Simplerole_Driver $driver_obj
         */
        $driver_obj = $this->create_driver($this->driver);
        $roles_obj = $driver_obj->role_exists($name) ?
                call_user_func(array(self::MODEL_NAME, 'factory'), $driver_obj, $this->model, $name) :
                NULL;
        return $roles_obj;
    }

//    public function has_role($name, $user_role) {
//        return call_user_func(array(self::MODEL_NAME, 'has_role'), $this->driver_obj, $this->model, $name, $user_role);
//    }

    public function __call($name, $arguments) {
        if (is_array($arguments[0]))
            return $this->_call_multiple_roles($name, $arguments);
        else
            return $this->_call_single_role($name, $arguments);
    }
    
    public function _call_single_role($name, $arguments) {
        array_unshift($arguments, $this->driver_obj, $this->model);
        return call_user_func_array(array(self::MODEL_NAME, $name), $arguments);
    }

    public function _call_multiple_roles($name, $arguments) {
        array_unshift($arguments, $this->driver_obj, $this->model);
        return call_user_func_array(array(self::MODEL_NAME, $name.'_multiple'), $arguments);
    }

    /**
     * Function which returns an array of rolenames which user belongs to.
     * NOTE: This is a generic implementation of this functionality which is most 
     * probably awfully slow compared to methods which would take advantage of
     * model/driver specifics. More over even this generic implementation is written
     * in lazy-slow manner. The function is meant mainly for debug/testing
     * purposes.
     * @param Model_Simplerole $user_role user role which the checks will be performed
     * @return array an array of role name user belongs to
     */
//    public function get_user_roles($user_role) {
//        $user_roles = array();
//        foreach ($this->get_roles() as $name => $role) {
//            if ($this->has_role($name, $user_role)) {
//                $user_roles[] = $name;
//            }
//        }
//        return $user_roles;
//    }

    /**
     * Factory for creation of a given roles' model using a specified driver.
     * @param string $model
     * @param string $driver
     * @return Model_Simplerole created object
     */
    public static function factory($model = 'Binary', $driver = 'File') {
        $this_name = __CLASS__;
        return new $this_name($model, $driver);
    }

    protected function create_driver($param) {
        $driver_factory_classname = self::MODEL_NAME . '_Driver';
        return call_user_func(array($driver_factory_classname, 'factory'), $param);
    }

}

?>
