<?php

/**
 * Description of file
 *
 * @author luk32
 */
class Model_Simplerole_Driver_File extends Model_Simplerole_Driver {

    /**
     * @var Kohana::Config $config configuration file with roles description
     */
    protected $file = '';
    protected $config = NULL;
    protected $roles = array();

    public function __construct($config = 'simpleauth') {
        $this->assign_config($config);
    }

    public function get_roles() {
        return $this->roles;
    }

    public function get_role($name) {
        if ( $this->role_exists($name) )
            return $this->roles[$name];
        else
            return NULL;
    }
    public function role_exists($name) {
        return array_key_exists($name, $this->roles);
    }

    protected function assign_config($config) {
        if ($config instanceof Kohana_Config_File) {
            $this->config = $config;
        } elseif (is_string($config)) {
            $this->assign_config_from_file($config);
        }
        if (!array_key_exists('roles', $this->config))
            throw new Exception('The specified config does not contain \'roles\' key!!');
        $this->roles = $this->config['roles'];
    }

    protected function assign_config_from_file($filename) {
        $this->file = $filename;
        $this->config = Kohana::config($filename);
    }

}

?>
