<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of driver
 *
 * @author luk32
 */
abstract class Model_Simplerole_Driver {

    abstract function get_roles();

    abstract function get_role($name);

    abstract function role_exists($name);

    /**
     * @param mixed $driver string $driver_name or an array('name' => $driver_name, 'params' => array $constructor_arguments)
     * @return Model_Simplerole_Driver
     */
    public static function factory($driver) {
        $params = self::parse_factory_param($driver);
        $driver = self::construct_object($params);
        return $driver;
    }

    /**
     * This function parses arugments passed to factory. It validates their type
     * and extracts desired class name and the constuctor parameter list of the
     * object to be created.
     * @param <type> $param parameters to be validated
     * @return array [0] => name of the driver; [1] = arguments for construtor
     */
    public static function parse_factory_param($param) {
        $name = NULL;
        $args = NULL;
        if (is_array($param)) {
            //handles name and arguments list
            if (!array_key_exists('name', $param)) {
                //name must exist
                throw new Exception('Simplerole_Driver::factory() parameter array must contain a \'name\' key.');
            }
            $name = $param['name'];
            if (!empty($param['params'])) {
                //set params if specified
                $args = $param['params'];
            }
        } elseif (is_string($driver)) {
            //handles simple string with name
            $name = $driver;
        }

        if (empty($name)) {
            throw new Exception('Wrong parameter type for Model_Simplerole_Driver::factory()');
        }

        return array($name, $args);
    }

    /**
     * This function handles actual creation of the new object
     * @param array Array returned by parse_factory_param array( [0] => $name; [1] => array $ctor_params)
     * @return <mixed> new instance of an object specified by name  __CLASS__ . '_'.params[0];
     */
    public static function construct_object(array $params) {
        $full_name = __CLASS__ . '_' . $params[0];
        $args = $params[1];
        $reflectionClass = new ReflectionClass($full_name);
        $obj = $reflectionClass->newInstanceArgs($args);
        return $obj;
    }

}

?>
