<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of binary
 *
 * @author luk32
 */
class Model_Simplerole_Binary extends Model_Simplerole {

    protected $properties;

    public function __construct($driver, $name) {
        parent::__construct($driver, $name);
        $this->properties = $this->driver->get_role($name);
    }

    public function user_is($user_role) {
        return (bool) ( $this->get_mask() & $user_role->role );
    }

    public function set_role(Model_User $user) {
        $mask = $this->get_mask();
        $user->role |= $mask;
    }

    public function get_mask() {
        return $this->properties['mask'];
    }

    public function get_human_name() {
        return $this->properties['human_name'];
    }

    public function sql_user_is($query, $column = 'role') {
        return $query->where($column, '&', $this->get_mask());
    }

    public function sql_user_is_not($query, $column = 'role') {
        return $query->where(DB::expr('~`' . $column . '`'), '&', $this->get_mask());
    }

    public static function get_user_roles($driver, $model, $user) {
        $user_roles = array();
        foreach ($driver->get_roles() as $name => $role) {
            if ($user->role & $role['mask']) {
                $user_roles[] = $name;
            }
        }
        return $user_roles;
    }

    public static function factory($driver, $model, $name) {
        $thisname = __CLASS__;
        return new $thisname($driver, $name);
    }

}

?>
