<?php

/**
 * Description of simplerole
 *
 * @author luk32
 */
abstract class Model_Simplerole {

    /**
     * @var Model_Simplerole_Driver $driver
     */
    protected $driver = NULL;
    protected $name = NULL;

    public function __construct($driver, $name) {
        $this->driver = $driver;
        $this->name = $name;
    }

    abstract public function user_is($user);

    public function get_name() {
        return $this->name;
    }

    public function get_human_name() {
        return $this->get_name();
    }

    /**
     * Factory for creation of a given roles' model using a specified driver.
     * @param string $model
     * @param string $driver
     * @param string $name role name
     * @return Model_Simplerole created object
     */
    public static function factory($driver, $model, $name) {
        $full_modelname = __CLASS__ . '_' . $model;
        return new $full_modelname($driver, $name);
    }

    public static function set_user_role($driver, $model, $rolename, $user) {
        $role = self::factory($driver, $model, $rolename);
        return call_user_func(array($role, 'set_role'), $user);
    }

    public static function get_user_roles($driver, $model, $user) {
        $full_modelname = __CLASS__ . '_' . ucfirst($model);
        $user_roles = array();
        if ($user != FALSE) {
            foreach ($driver->get_roles() as $name => $role) {
                if (call_user_func(array($full_modelname, 'has_role'), $driver, $model, $name, $user)) {
                    $user_roles[] = $name;
                }
            }
        }
        return $user_roles;
    }

    public static function has_role($driver, $model, $name, $user) {
        if(empty($user)) return FALSE;
        $role = self::factory($driver, $model, $name);
        return call_user_func(array($role, 'user_is'), $user);
    }

    public static function has_role_multiple($driver, $model, array $rolenames, $user) {
        if(empty($user)) return FALSE;
        foreach ($rolenames as $rolename) {
            $role = self::factory($driver, $model, $rolename);
            if ($role->user_is($user))
                return TRUE;
        }
        return FALSE;
    }

    /**
     * @param <type> $driver
     * @param <type> $model
     * @param array $rolenames
     * @param <type> $query_builder
     */
    public static function sql_user_is_multiple($driver, $model, array $rolenames, $query_builder) {
        foreach ($rolenames as $rolename) {
            $role = self::factory($driver, $model, $rolename);
            $query_builder = $role->sql_user_is($query_builder);
        }
        return $query_builder;
    }

    public static function sql_user_is_not_multiple($driver, $model, array $rolenames, $query_builder) {
        foreach ($rolenames as $rolename) {
            $role = self::factory($driver, $model, $rolename);
            $query_builder = $role->sql_user_is_not($query_builder);
        }
        return $query_builder;
    }

}

?>
