<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of rights
 *
 * @author luk32
 */
class Model_Auth_Rights extends ORM {

    protected $default_rights = array();
    const ROLES_TABLE_NAME = 'auth_user_roles';
    protected $_table_name = 'auth_rights';
    protected $_has_many = array(self::ROLES_TABLE_NAME => array('through' => 'auth_user_role_has_auth_rights'));

    public function __construct($id = NULL) {
        if ($this->is_id($id)) {
            parent::__construct($id);
        } else {
            parent::__construct();
            $this->find_ais($id);
        }
    }

    public function __get($name) {
        if ($name === 'roles') {
            $name = self::ROLES_TABLE_NAME;
        }
        return parent::__get($name);
    }

    public function get_roles($filter = array(), $as_array = TRUE) {
        $roles = $this->db_query($filter);
        if ($as_array) {
            $roles = $roles->as_array($this->_primary_key);
        }
        return $roles;
    }

    public function get_rights($roles, $reduce = TRUE) {
        $reduction = $reduce ? 'MAX' : NULL;
        $rights = $this->db_query($roles, $reduction);

        while ($this->empty_set($rights) AND !$this->empty_pk()) {
            $this->find_ascendant_ais($this->__get($this->_primary_val));
            $rights = $this->db_query($roles, $reduction);
        }


        $rights = $rights->as_array($this->_primary_val, 'rights');
        if ($reduce AND array_key_exists('', $rights)) {
            return $this->get_default_rights($this->name,$roles);
        }

        return $rights;
    }

    public function find($id = NULL) {
        //if $id is numeric, treat it as a normal find call
        if ($this->is_id($id))
            return parent::find($id);

        //else look for action identifier
        $action = $this->find_ais($id);

        //if still not found get some outside defaults
        if ($action->empty_pk()) {
            $action = $this->get_default_action($id);
        }
        return $action;
    }

    /**
     * @param string $ais Action Identifier String
     * @return Model_Rights object for given ais
     */
    public function find_ais($ais) {
        //try to find given ais
        $this->find_by_column($ais);
        if (!$this->empty_pk())
            return $this;

        //if not found, split the ais into element name table and get the action name
        return $this->find_ascendant_ais($ais);
    }

    protected function find_ascendant_ais($ais) {
        //split the ais into element name table and get the action name
        $element = explode('.', $ais);
        $action = array_pop($element);
        //try to find parent element action by cutting off element name bits
        do {
            array_pop($element);
            $ais = implode('.', $element) . '.' . $action;
            $this->find_by_column($ais);
        } while ($this->empty_pk() AND count($element) > 0);
        //finally if still not found try the default - pure "action_name"
        if ($this->empty_pk())
            $this->find_by_column($action);
        return $this;
    }

    protected function get_default_rights($name, $roles = array()) {
        throw new Kohana_Exception('No rights for roles `:roles` on action `:action` have been specified.', array(':action' => ($name), ':roles' => implode(`,`, $roles)));
        return $this->default_rights;
    }

    protected function get_default_action($id = NULL) {
        throw new Kohana_Exception('Action `:action` nor ascendants could be found. Check database and spelling.', array(':action' => $id));
    }

    protected function db_query($roles, $reduction = NULL) {
        $select = $this->db_rights('rights');
        if ($reduction !== NULL AND $reduction != '') {
            $select = array(DB::expr($reduction . '(' . $select . ')'), 'rights');
        }
        $query_builder = $this->roles->select($select);

        //apply filters
        if (!empty($roles)) {
            $query_builder->and_where_open();
            foreach ($roles as $rule) {
                $query_builder->or_where('name', '=', $rule);
            }
            $query_builder->and_where_close();
        }
        $results = $query_builder->find_all();
        if ($this->empty_set($results)) {
            // OR is needed 'cause reduction operation performed on an empty set still gives one row of results
            // with NULL at all columns; thus the check if the id is NULL there
            $results = $this->select($select)->
                            join($this->db_rights())->on($this->db_rights('auth_rights_id'), '=', $this->_primary_key)->
                            where($this->db_rights('auth_user_role_id'), '=', 0)->
                            and_where($this->_primary_key, '=', $this->pk())->
                            find_all();
        }
        return $results;
    }

    protected function db_rights($column = NULL) {
        if (!empty($column)) {
            $column = '.`' . $column . '`';
        }
        return DB::expr('`' . $this->_db->table_prefix() . $this->_has_many[self::ROLES_TABLE_NAME]['through'] . '`' . $column);
    }

    protected function is_id($id) {
        return is_null($id) OR is_int($id) OR ctype_digit($id);
    }

    protected function empty_set($results) {
        return ($results->count() == 0 OR $results[0]->id == NULL OR $results[0]->id == 0);
    }

    private function find_by_column($value, $col = NULL) {
        if ($col === NULL) {
            $col = $this->_primary_val;
        }

        return $this->where($col, '=', $value)->find();
    }

}

?>
