<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Authcore extends Controller_Template {
   
    public $form_scenarios = array();
    public $form_rules = array();
    public $form_fields = array();
    public $form_errors = array();
    public $form_post = array();
    
    public function make_field($field, $rules = array(), $default = '', $scenario = array('*')) {
        $this->form_fields[$field] = $default;
        $this->form_rules[$field] = $rules;
        $this->form_errors[$field] = '';
        $this->form_scenarios[$field] = $scenario;
    }
    public function set_fields($submit = NULL, $messages = 'validate') {
        if (!empty($submit)) {
            $this->form_fields = arr::overwrite($this->form_fields, $this->form_post->as_array());
            $this->form_errors = arr::overwrite($this->form_errors, $this->form_post->errors($messages));
        }
    }
    public function form_populate_view($submit = NULL) {       
        $this->set_fields($submit);        
        $this->template->set_global('form_fields', $this->form_fields);
        $this->template->set_global('form_errors', $this->form_errors);        
    }
    public function validate($scenario = '') {
        foreach ($this->form_rules as $field => $rules) {
            if ((in_array('*', $this->form_scenarios[$field])) OR (in_array($scenario, $this->form_scenarios[$field]))) {
                foreach ($rules as $rule) {
                    $this->form_post->rule($field, $rule);
                }
            }
        }
        return $this->form_post->check();
    }
    
}
?>

