<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of authorize
 *
 * @author luk32
 */
class authorize {

    /**
     * @property Model_Rights $model rights model object for accessing rights data
     * @property Model_Roles $roles roles model to check for rights
     */
    protected $model = NULL;
    protected $roles = NULL;

    /**
     * @var Model_Roles $action_orm
     */
    public function __construct($roles) {
        if ($roles === NULL)
            throw new Exception('$roles is NULL. Cannot instatiate authorization module for no roles.');

        $this->model = new Model_Auth_Rights;
        $this->roles = $roles;
    }

    public function has_right($user, $action) {
        return current($this->get_rights($user, $action, TRUE));
    }

    public function get_rights($user, $action, $reduce = TRUE) {
        $action_orm = $this->model->find($action);
        $user_roles = $this->roles->get_user_roles($user);
        $action_rigths = $action_orm->get_rights($user_roles, $reduce);
        return $action_rigths;
    }

    public function get_roles($user, $action) {
        $action_orm = $this->model->find($action);
        $user_roles = $this->roles->get_user_roles($user);
        $action_roles = $action_orm->get_roles($user_roles);
        return $action_roles;
    }

    public static function factory($roles) {
        $name = __CLASS__;
        return new $name($roles);
    }

    /**
     * @staticvar <type> $instance
     * @param <type> $roles
     * @return authorize Authorization engine instance
     */
    public static function instance($roles = NULL) {
        static $instance;
        if (empty($instance)) {
            if ($roles === NULL) {
                throw new Exception('$roles is NULL. ' . __CLASS__ . ' is not instatiated yet. $roles must be specified.');
            }
            $instance = self::factory($roles);
        }
        return $instance;
    }

}

?>
