<?php

/**
 * Auth_Modeler
 *
 * @package		simpleauth for Kohana 3.x
 * @author			thejw23
 * @copyright		(c) 2010 thejw23
 * @license		http://www.opensource.org/licenses/isc-license.txt
 * @version		1.0 BETA
 * @last change		initial release
 *
 * modified version of Simple_Modeler, removed all methods not needed for Auth
 * class name changed to prevent conflicts while using original Simple_Modeler
 */
class authmodeler extends ORM_Extended {

    // if true all fields will be trimmed before save
    protected $_auto_trim = TRUE;
    // timestamp fields, they will be auto updated on db update
    // update only if table has a column with given name
    public $timestamp = Array('time_stamp');
    // timestamp fields updated only on db insert
    public $timestamp_created = Array('time_stamp_created');
    // fetch only those fields, if empty select all fields
    public $select = '*';

    /**
     *  Allows for setting data fields in bulk
     *  [luk32]: alias for ORM->values() with autotrim
     * @param array $data data passed to $data
     * @param bool $ignore_null fields with NULL in data will not be set
     * @return object
     */
    public function set_fields($data, $ignore_null = FALSE) {
        if ($ignore_null) {
            foreach ($data as $key => $value) {
                if (is_null($data[$key]))
                    unset($data[$key]);
            }
        }
        if ($this->_auto_trim) {
            foreach ($data as $key => $value) {
                if (is_string($value)) {
                    $data[$key] = trim($value);
                }
            }
        }
        $this->values($data);
        return $this;
    }

    /**
     *  Saves the current $data to DB
     *
     * @return mixed
     */
    public function save() {
        $this->apply_timestamp($this->loaded());
        $return = parent::save();

        if ($this->pk() AND !empty($this->hash_field)) {
            db::update($this->table_name)->set(array($this->hash_field => sha1($this->_table_name . $id . $this->hash_suffix)))->where($this->_primary_key, '=', $this->pk())->execute();
        }
        return $return;
    }

    /**
     * load single record based on unique field value
     *
     * @param array|integer $value column value
     * @param string $key column name
     * @return object
     */
    public function load($value, $key = NULL) {
        (empty($key)) ? $key = $this->_primary_key : NULL;

        return $this->where($key, '=', $value)->find();
    }

    /**
     *  Returns single record without using $data
     *
     * @param array|integer $value column value
     * @param string $key column name
     * @return mixed
     */
    public function fetch_row($value, $key = NULL) {
        (empty($key)) ? $key = $this->_primary_key : NULL;

        $data = db::select($this->select)->from($this->table_name)->where($key, '=', $value)->execute();

        if (count($data) === 1 AND $data = $data->current())
            return $data;

        return NULL;
    }

    /**
     *  clear values of $data and $data_original
     *
     * @return
     */
    public function clear_data() {
        array_fill_keys($this->_object, '');
        array_fill_keys($this->_changed, '');
    }

    /**
     *  Set columns for select
     *
     * @param array $fields query select
     * @return object
     */
    public function select($fields = array()) {
        if (empty($fields))
            return $this;

        if (is_array($fields)) {
            $this->select = $fields;
        } elseif (func_num_args() > 0) {
            $this->select = func_get_args();
        }

        return $this;
    }

    /**
     *  check if data has been retrived from db and has a primary key value other than 0
     *
     * @param string $field data key to be checked
     * @return boolean
     */
    public function loaded($field = NULL) {
        (empty($field)) ? $field = $this->_primary_key : NULL;
        return (intval($this->$field) !== 0) ? TRUE : FALSE;
    }

    /**
     *  Checks if given key is a timestamp and should be updated
     *
     * @param string $key key to be checked
     * @return array
     */
    public function apply_timestamp($loaded = FALSE) {
        // update timestamp fields with current datetime
        if ($loaded) {
            if (!empty($this->timestamp) AND is_array($this->timestamp))
                foreach ($this->timestamp as $field) {
                    if (!array_key_exists($field, $this->_changed) AND empty($this->$field)) {
                        $this->__set($field, date('Y-m-d H:i:s'));
                    }
                }
        } else {
            if (!empty($this->timestamp_created) AND is_array($this->timestamp_created)) {
                foreach ($this->timestamp_created as $field)
                    if (!array_key_exists($field, $this->_changed) AND empty($this->$field)) {
                        $this->__set($field, date('Y-m-d H:i:s'));
                    }
            }
        }
    }

    /**
     *  magic set to $data
     *
     * @param string $key key to be modified
     * @param string $value value to be set
     * @return object
     */
    public function __set($key, $value) {
        if ($this->_auto_trim AND is_string($value)) {
            $value = trim($value);
        }
        return parent::__set($key, $value);
    }

}