<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of extended
 *
 * @author luk32
 * @todo PERFORMANCE explode paths in case of $this->has_column() could be avoided
 */
class ORM_Extended extends ORM {
    const DEBUG = FALSE;
    //put your code here
    // Parents of this table (model)
    protected $_extends = array();
    //changed parents; in current implementation saved as pairs of ( modelname => model_instance )
    protected $_changed_exends = array();
    protected $_path2model_cache = array();
    protected $_debug = NULL;
    protected $profiler_tokens = NULL;

    /**
     * @var ORM $model
     */

    /**
     *
     * @param <type> $id
     */
    public function __construct($id = NULL) {
        $profiler_token = Profiler::start('ORM_Extended', 'construct');

        FB::group('jst_debug', array('Collapsed' => TRUE));

        $this->_debug = (Kohana::$environment === Kohana::DEVELOPMENT AND self::DEBUG);
        //    $this->_debug = (get_class($this) == 'Model_Site');

        $load_with = array();
        $belongs_to = array();
        foreach ($this->_extends as $ascendant_modelname => $properties) {
            if (array_key_exists('table_name', $properties)) {
                $tbl_name = $properties['table_name'];
                unset($properties['table_name']);
            } else {
                $tbl_name = $ascendant_modelname;
            }
            $load_with[$ascendant_modelname] = $tbl_name;
            $belongs_to[$ascendant_modelname] = $properties;
        }
        $this->_load_with = array_merge($this->_load_with, $load_with);
        $this->_belongs_to = array_merge($this->_belongs_to, $belongs_to);
        //construct
        parent::__construct($id);
        $this->_debug AND $this->debug_msg(' [' . $this->debug_id($id) . '] construct.');
        Profiler::stop($profiler_token);
    }

    public function __clone() {
        $this->_debug AND $this->debug_msg('is a clone.');
    }

    public function __set($path, $value) {
        $this->_debug AND $this->debug_msg('__set: ' . $this->_object_name . ' -> ' . $path . ' to `' . $value . '`');
        $new_path = $this->find_path($path);
        list($model, $column, $new_path) = $this->explode_path($new_path);
        if ($model !== $this) {
            $this->_debug AND $this->debug_msg('` transferred to ' . $this->debug_model($model));
            $model->$column = $value;
            $this->remember_to_save($model);
            return;
        }

        return parent::__set($column, $value);
    }

    public function __get($path) {
        $profiler_token = Profiler::start('ORM_Extended', 'get');
        $this->_debug AND $this->debug_msg('__get: ' . $this->_object_name . ' -> ' . $path);
        $new_path = $this->find_path($path);
        list($model, $column, $new_path) = $this->explode_path($new_path);
        if ($model !== $this) {
            $this->_debug AND $this->debug_msg('` transferred to ' . $this->debug_model($model));
            return $model->$column;
        }

        $this->_debug AND $this->debug_msg('__get(`' . $path . '`): delegating to parent.');
        Profiler::stop($profiler_token);
        return parent::__get($column);
    }

    public function values($values) {
        $this->_debug AND $this->debug_msg('set values:');
        $this->_debug AND $this->debug_msg($values);
        foreach ($values as $key => $value) {
            $this->_debug AND $this->debug_msg('set value: ' . $key . ' => ' . $value);
            $path = $this->find_path($key);
            list($model, $column, $path) = $this->explode_path($path);

            // if the model is not $this delegate execution onto the right one
            if ($model !== $this) {
                $this->_debug AND $this->debug_msg(
                                get_class($this) . '::values on `' . $key . '` transferred to ' .
                                get_class($model) . '[' . spl_object_hash($model) . '] as `' .
                                $path . ':' . $column . '`');
                $model->$column = $value;
                $this->remember_to_save($model);
                unset($values[$key]);
            }
        }
        return parent::values($values);
    }

    public function as_array() {
        $array = parent::as_array();
        foreach ($this->_extends as $foreign_modelname => $foreign_table) {
            $foreign_table = $this->$foreign_modelname;
            foreach ($foreign_table->list_columns() as $foreign_col) {
                $col_name = $foreign_col['column_name'];
                if (!array_key_exists($col_name, $array)) {
                    $array[$col_name] = $foreign_table->$col_name;
                }
            }
        }
        return $array;
    }

    public function save() {
        $this->_debug AND $this->debug_msg('save.');
        //save parents
        foreach ($this->_changed_exends as $foreign_model) {
            $this->_debug AND $this->debug_msg('Saving ' . $this->debug_model($foreign_model));
            $foreign_model->save();
            $this->_debug AND $this->debug_msg($foreign_model);
        }

        //if new assign ids of extends (to create realtions)
        if ($this->is_new()) {
            foreach ($this->_changed_exends as $name => $instance) {
                $foreign_key_name = $this->_extends[$name]['foreign_key'];
                $this->$foreign_key_name = $instance->pk();
            }
        }

        $this->_debug AND $this->debug_msg($this->as_array());
        return parent::save();
    }

    public function find($id = NULL) {
        $this->clear_extends();
        return parent::find($id);
    }

    protected function clear_extends() {
        $this->_debug AND $this->debug_msg('clear_extends');
        $this->_changed_exends = array();
        $this->_path2model_cache = array();
        $this->_related = array();
    }

    /**
     * [!!] Warning behaviour of this function is not exactly the same as
     * ORM::is_unique(). In case of ($id === NULL) this on will not fallback to
     * $this->exists(). Instead it will take $this->id as default id.
     * @param <type> $field
     * @param <type> $value
     * @param <type> $id
     * @return int number of the objects which field is equal to value
     */
    public function is_unique($field, $value = NULL, $id = NULL) {
        /* this model instance must be instatiated to the right object (via id)
         * so the related models would be chosen right.                       */
        $model = ($id === NULL) ? $this : $this->find($id);
        $path = $model->find_path($field);
        $this->_debug AND $this->debug_msg('is_unique: ' . $path . '(' . $field . ',' . $value . ',' . $this->debug_id($id) . '[->' . $this->debug_id($model->pk()) . '])');
        list($related_model, $column, $new_path) = $model->explode_path($path);

        if ($related_model !== $this) {
            $this->_debug AND $this->debug_msg('transferred to ' . $this->debug_model($related_model) . $new_path . ' -> ' . $column . ' with (' . $field . ',' . $value . ',' . $related_model->pk() . ')');
            return $related_model->is_unique($field, $value, $related_model->pk());
        }
        return parent::is_unique($field, $value, $this->pk());
    }

    public function delete($id = NULL) {
        $model = ($id === NULL) ? $this : $this->find($id);
        foreach ($model->_extends as $foreign_modelname => $properties) {
            $model->$foreign_modelname->delete();
        }
        return parent::delete($id);
    }

    /**
     *
     * @param <type> $column
     * @param <type> $op
     * @param <type> $val
     * @TODO: Translation of column name to fully qualified name. _table_._column_
     * To avoid ambigous column names in joins
     */
    public function where($column, $op, $val) {
        $this->_debug AND $this->debug_msg('where(' . $column . ',' . $op . ',' . $val . ')');
        //$path = $this->find_path($column);
        //list($model, $column, $new_path) = $this->explode_path($path);
        //return parent::where($model->table_name().'.'.$column, $op, $val);
        return parent::where($column, $op, $val);
    }

    /**
     * @param string $column column name; optionally column might be prepended with path specifing where to start the search
     * @return string full relations path to the column or Exception if not found
     */
    protected function find_path($path) {
        //check if the column belongs to the current model
        if ($this->has_column($path))
            return $path;
        $this->_debug AND $this->debug_msg('find_path(`' . $path . '`)');

        list($model, $column, $new_path) = $this->explode_path($path);

        // if the model is not $this delegate execution onto the right one
        // and prepend the result with its path
        if ($model !== $this) {
            $this->_debug AND $this->debug_msg('transferred to ' . get_class($model) . '[' . spl_object_hash($model) . '] find_path(`' . $column . '`)');
            return $new_path . ':' . $model->find_path($column);
        }


        //if failed look into associates
        foreach ($this->_load_with as $foreign_modelname => $foreign_table) {
            try {
                $foreign_model = parent::__get($foreign_modelname);
                return $foreign_modelname . ':' . $foreign_model->find_path($column);
            } catch (Kohana_Exception $e) {

            } //mask the error to check next ascendant
        }
        //if still not found generate the error
        //$this->_debug AND $this->debug_msg ($this);
        throw new Kohana_Exception('Column `' . $column . '` could not be found in model `' . get_class($this) . '` - table `' . $this->_table_name . '` nor its ascendants.');
    }

    protected function explode_path($path) {
        $colon = strrpos($path, ':');

        if ($colon === FALSE) {
            $column = $path;
            $model = $this;
            $model_path = '';
        } else {
            $column = substr($path, $colon + 1);
            $model_path = substr($path, 0, $colon);
            $model = $this->path2model($model_path);
        }
        $this->_debug AND $this->debug_msg('explode_path(`' . $path . '`) -> ' . $model_path . ':' . $this->debug_model($model) . $column);

        return array($model, $column, $model_path);
    }

    protected function path2model($model_path) {
        if (array_key_exists($model_path, $this->_path2model_cache)) {
            $this->_debug AND $this->debug_msg('Cache hit ' . $model_path . '[' . spl_object_hash($this->_path2model_cache[$model_path]) . ']');
        } else {
            $this->_debug AND $this->debug_msg('Explore path: `' . $model_path . '`');
            $path = explode(':', $model_path);
            $root = array_shift($path);
            $model = parent::__get($root);
            $this->_debug AND $this->debug_msg('Model ' . $root . ' => ' . get_class($model) . '[' . spl_object_hash($model) . '] ');
            foreach ($path as $model_name) {
                $this->_debug AND $this->debug_msg('Model ' . $root . ' => ' . get_class($model) . '[' . spl_object_hash($model) . '] ');
                $model = $model->$model_name;
            }
            $this->_path2model_cache[$model_path] =
                    /* Dunno why but the clone is needed. Otherwise newly created
                     * relation will forget its propeties. It does despite being
                     * cached properly. Set debug to true and check yourself   */
                    $model->is_new() ? clone $model :
                    $model;
            $this->_debug AND $this->debug_msg('Cache store ' . $model_path . '[' . spl_object_hash($this->_path2model_cache[$model_path]) . ']');
        }
        return $this->_path2model_cache[$model_path];
    }

    protected function path2modelname($path) {
        $colon = strrpos($path, ':');
        $modelname = substr($path, $colon + 1);
        return $modelname;
    }

    protected function remember_to_save(Kohana_ORM $model) {
        $this->_debug AND $this->debug_msg("remeber to save " . $this->debug_model($model) . " as " . $model->get_object_name());

        if (!array_key_exists($model->get_object_name(), $this->_changed_exends)) {
            $this->_changed_exends[$model->get_object_name()] = $model;
        } elseif ($this->_changed_exends[$model->get_object_name()] !== $model) {
            $hashes = spl_object_hash($this->_changed_exends[$model->get_object_name()]) == spl_object_hash($model) ? 'TRUE' : 'FALSE';
            $error_msg = 'Trying to save the second instance of the same modelname!' . "\n" .
                    'Hashes: cache [' . spl_object_hash($this->_changed_exends[$model->get_object_name()]) . '] == $model [' . spl_object_hash($model) . '] is ' . $hashes . '.';
            $this->_debug AND $this->debug_msg($error_msg);
            throw new Exception($error_msg);
        }
    }

    protected function start_query() {
        $query = $this;
        foreach ($this->_load_with as $model => $table) {
            $query->join($table, 'LEFT')->on($this->_table_name . '.' . $this->_belongs_to[$model]['foreign_key'], '=', $table . '.' . 'id');
        }
        return $query;
    }

    public function __destruct() {
        $this->_debug AND $this->debug_msg('destruct.');
        FB::groupEnd();
    }

    protected function _build($type) {
        $return = parent::_build($type);
        foreach ($this->_load_with as $model => $table) {
            $this->_db_builder->join($table, 'LEFT')->on($this->_table_name . '.' . $this->_belongs_to[$model]['foreign_key'], '=', $table . '.' . 'id');
        }
        return $return;
    }

    protected function debug_msg($msg) {
        $token = Profiler::start('ORM_Extended', 'debug');
        $location = __FILE__ . '[' . __LINE__ . '] ' . $this->debug_model() . ':';
        if (is_string($msg)) {
            var_dump($location . $msg);
            FB::log($location . $msg, 'location, msg');
        } else {
            var_dump($location);
            var_dump($msg);
            FB::log($location, 'location');
            FB::log($msg, 'msg');
        }
        Profiler::stop($token);
    }

    protected function debug_id($id) {
        return ( is_null($id) ? 'NULL' : $id );
    }

    protected function debug_model($model = NULL) {
        if ($model === NULL) {
            $model = $this;
        }
        try {
            $id = $this->debug_id($model->pk());
        } catch (ErrorException $e) {
            $id = 'pk() failed';
        }

        return get_class($model) . '[' . $id . '][' . spl_object_hash($model) . '] ';
    }

    protected function setup_relations() {
        //prepare realtions
//        foreach ($this->_sorting as $column => $order) {
//            if (!$this->has_column($column)) {
//                $new_path = $this->find_path($column);
//                list($model, $column, $new_path) = $this->explode_path($new_path);
//                $this->_sorting[$model->get_table_name().'.'.$column];
//            }
//        }
    }

}

?>
