<?php

defined('SYSPATH') or die('No direct script access.');

class ORM extends Kohana_ORM implements ArrayAccess {

    /**
     * for compatibility with old Model structure; get() is/was supposed to return
     * the ORM object
     * @deprecated
     */
    public function get() {
        return $this;
    }

    /**
     * for compatibility with old Model structure;
     * DO NOT USE THIS
     * use values/save explicitly
     * @deprecated
     */
    public function save_from_array($array) {
        $this->values($array);
        return $this->save();
    }

    /**
     * checks whether the column exists in the model
     * @param string $column coumn name
     * @return bool TRUE if it does, FALSE otherwise
     */
    public function has_column($column) {
        /* TODO: check this; maybe only pk column is the problem
         * black magic ... sometimes you can get __set method called when $this->_db
         * is still unset; Somewhere mysql_fetch_object is called and it issues those sets */
        if ($this->_db === 'default') {
            FB::warn('has_column(' . $column . '). Uwaga moze niedzialac', 'has_column');
            return TRUE;
        }

        $this->reload_columns();
        return
        array_key_exists($column, $this->_table_columns) OR
        array_key_exists($column, $this->_related) OR
        array_key_exists($column, $this->_belongs_to) OR
        array_key_exists($column, $this->_has_many) OR
        array_key_exists($column, $this->_has_one);
    }

    /**
     * Just an alias for values
     * @param <type> $array 
     */
    public function set_from_array($array) {
        return $this->values($array);
    }

    /**
     * checks how many fields for given condition exists in the table
     * @param string $field column name
     * @param mixed $value value to check; defaul value in $column of $this->object
     * @param string $operator operator to be used
     * @return integer number of records
     */
    public function exists($field, $value = NULL, $operator = '=') {
        if ($value === NULL) {
            $value = $this->$field;
        }
        return $this->where($field, $operator, $value)->count_all();
    }

    public function is_unique($field, $value = NULL, $id=NULL) {
        if (is_null($id)) {
            return $this->exists($field, $value);
        } else {
            if ($value === NULL) {
                $value = $this->$field;
            }
            return $this->where($field, '=', $value)->where($this->_table_name . '.' . $this->_primary_key, '!=', $id)->count_all();
        }
    }

    public function is_new() {
        return ( $this->empty_pk() OR $this->pk() == 0 OR isset($this->_changed[$this->_primary_key]) );
    }

    public function get_object_name() {
        return $this->_object_name;
    }

    /**
     * Function for deleting an object and calling a trigger if object exists
     * and is really going to be deleted.
     * @param $id id of the field to be deleted
     */
    public function delete($id = NULL) {
        if ($id === NULL) {
            $id = $this->pk();
        }
        $object = $this->where($this->_table_name.'.'.  $this->_primary_key, '=', $id)->find();
        if ($object->empty_pk()) {
            //if not found skip rest of the process
            return $this;
        }
        $object->before_delete();
        $object->delete_self($object->pk());
        return $this;
    }

    /**
     * Trigger which will be called before the actual DB::delete() call
     */
    protected function before_delete() {

    }

    public function get_range($from, $number) {
        $items = $this->offset($from)->limit($number)->find_all();
        return $items;
    }

    public function get_range_as_items_array($from, $number) {
        $items = $this->get_range($from, $number);
        $items_array = array();
        foreach ($items as $item) {
            $items_array[$item['id']] = $item->as_array();
        }
        return $items_array;
    }

    public function get_count_all() {
        return $this->count_all();
    }

    /**
     * @return int number of deleted rows, should be 1 in case the object with
     * id existed or 0. Otherwise it's a serious error
     */
    protected function delete_self($id) {
        $deleted_rows = DB::delete($this->_table_name)
                        ->where($this->_primary_key, '=', $id)
                        ->execute($this->_db);
        return $deleted_rows;
    }

    /**
     * mapuje getOffset na standardowy __get
     * @param mixed $offset offset in register
     * @return mixed zwraca pod zadanym offsetem
     */
    public function offsetGet($offset) {
        return $this->__get($offset);
    }

    /**
     * mapuje setOffset na standardowy __set
     * @param mixed $offset offset in request
     * @param mixed $value wartosc do ustawienia
     */
    public function offsetSet($offset, $value) {
        return $this->__set($offset, $value);
    }

    /**
     * usuwa obiekt pod danym offsetem
     * @param mixed $offset offset in request
     */
    public function offsetUnset($offset) {
        if (isset($this->_object[$offset])) {
            prev($this->_object[$offset]);
            $key = key($this->_object[$offset]);
            if (is_null($key)) {
                reset($this->_object[$offset]);
            }
            unset($this->_object[$offset]);
        }
    }

    public function offsetExists($offset) {
        //Lightweight version; checks if offset belongs strictly to the object
        return $this->has_column($offset);

//  Heavy weight version; checks if you can accually perform __get
//  which goes through relations.
//        try {
//            $test = $this->__get($offset);
//        } catch (Kohana_Exception $exc) {
//            return FALSE;
//        }
//        return TRUE;
    }

    //ArrayAccess END


    public function reset($next = TRUE) {
        if ($next AND $this->_db_reset) {
            $this->_db_pending = array();
            $this->_db_applied = array();
            $this->_db_builder = NULL;
            $this->_with_applied = array();
        }

        // Reset on the next call?
        $this->_db_reset = ($next AND $this->_db_reset);

        return $this;
    }

}
