<?php

defined('SYSPATH') or die('No direct script access.');

/**
 * @group option
 */
class GroupTest extends Kohana_Unittest_TestCase {

    private static $counter = 0;
    const GROUP_NAME = 'grupa';
    const OPTION_NAME = 'opcja';
    const VALUE = 'wartosc';

    public function setUp() {
	parent::setUp();
	$this->object = new Option_Group(self::GROUP_NAME, $this->prepare_mock_array());
	self::$counter = 0;
    }

    private function prepare_mock($methods = array()) {
	$methods[] = '__get';
	$mock = $this->getMock('Model_Option_Orm', $methods);
	$mock->expects($this->any())
		->method('__get')
		->will($this->returnCallback(array($this, 'static_counter')));
	return $mock;
    }

    public function static_counter() {
	return self::GROUP_NAME . '_' . self::$counter++;
    }

    private function prepare_mock_array() {
	$array[] = $this->prepare_mock();

	return $array;
    }

    /**
     * @expectedException Exception
     */
    public function test__construct_will_throw_Exception_if_second_arg_is_empty() {
	$object = new Option_Group(self::GROUP_NAME, array());
    }

    /**
     * @expectedException Exception
     */
    public function test__construct_will_throw_Exception_if_second_arg_not_array() {
	$object = new Option_Group(self::GROUP_NAME, 1);
    }

    public function test__get() {
	$orm = new Model_Option_Orm();
	$orm->name = self::GROUP_NAME . '_' . self::OPTION_NAME;
	$orm->value = self::VALUE;
	$object = new Option_Group(self::GROUP_NAME, array($orm));
	$option_name = self::OPTION_NAME;
	$object_option_name = $object->$option_name;
	$this->assertEquals(self::VALUE, $object_option_name);
    }

    /**
     * @expectedException Exception
     */
    public function test_throw_exception_if_option_dont_exists() {
	$bla = $this->object->bla;
    }

    /**
     * @depends test__get
     */
    public function test__set() {
	$orm = new Model_Option_Orm();
	$orm->name = self::GROUP_NAME . '_' . self::OPTION_NAME;
	$orm->value = self::VALUE;
	$object = new Option_Group(self::GROUP_NAME, array($orm));
	$option_name = self::OPTION_NAME;
	$object->$option_name = 22;
	$this->assertEquals($object->$option_name, 22);
    }

    public function test_save() {
	$mock = $this->prepare_mock(array('save'));
	$mock->expects($this->once())
		->method('save');
	$object = new Option_Group(self::GROUP_NAME, array($mock));
	$result = $object->save();
	$this->assertTrue($result);
    }

    public function test_from_array_none_options_in_array() {
	$options = array();
	$options[] = $this->prepare_option_mock_with_set(FALSE);
	$options[] = $this->prepare_option_mock_with_set(FALSE);
	$object = new Option_Group(self::GROUP_NAME, $options);
	$values = array('bla' => 1, 'bla2' => 2);
	$object->from_array($values);
    }

    /**
     * przygotowuje mock'i opcji dla testów funkcji from_array
     * podmieniona jest metoda __set
     */
    private function prepare_option_mock_with_set($expects, $value='') {
	$mock = $this->prepare_mock(array('__set'));
	if ($expects) {
	    $mock->expects($this->exactly((int) $expects))
		    ->method('__set')
		    ->with($this->equalTo('value'), $this->equalTo($value));
	} else {
	    $mock->expects($this->never())
		    ->method('__set');
	}
	return $mock;
    }

    public function test_from_array_some_options_in_array() {
	$options = array();
	$options[] = $this->prepare_option_mock_with_set(1, 1);
	$options[] = $this->prepare_option_mock_with_set(FALSE);
	$object = new Option_Group(self::GROUP_NAME, $options);
	$values = array(1, 'bla2' => 2);
	$object->from_array($values);
    }

    public function test_from_array_all_options_in_array() {
	$options = array();
	$options[] = $this->prepare_option_mock_with_set(1, 1);
	$options[] = $this->prepare_option_mock_with_set(1, 2);
	$object = new Option_Group(self::GROUP_NAME, $options);
	$values = array(1, 2);
	$object->from_array($values);
    }

    public function tearDown() {
	parent::tearDown();
    }

}
?>    