<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of OptionTest
 *
 * @author A-Tech.pl
 */
require_once dirname(__FILE__) . '/../classes/model/option/ORM';

/**
 *
 * @group option
 */
class OptionTest extends Kohana_Unittest_TestCase {
    const GROUP_NAME = 'group_name';

    public function setUp() {
	parent::setUp();
	$this->clearDatabaseTable();
    }

    private function clearDatabaseTable() {
	$orm = new Model_Option_Orm;
	$orm->delete_all();
    }

    public function testFactoryWhenGroupExists() {
	$config = Kohana::config('option.' . self::GROUP_NAME);

	$group = Option::factory(self::GROUP_NAME);

	$this->assertEquals('Option_Group', get_class($group));
	foreach ($config as $key => $value) {
	    $this->assertEquals($value, $group->$key);
	}
    }

    /**
     * @expectedException Exception
     */
    public function testFactoryWhenGroupDontExists() {
	$group = Option::factory('111');
    }

    public function tearDown() {
	$this->clearDatabaseTable();
	parent::tearDown();
    }

}
?>
