<?php

defined('SYSPATH') or die('No direct script access.');

class Option_Group implements ArrayAccess {

    protected $group_name = '';
    protected $options = array();

    public function __construct($group_name, $options) {
        $this->group_name = $group_name;

        $this->throw_exception_if_options_are_not_array($options);
        $this->throw_exception_if_options_are_empty($options);

        $this->options = $this->prepare_options($options);
    }

    private function throw_exception_if_options_are_not_array($options) {
        if (!is_array($options)) {
            throw new Exception('Argument $options powinien byc tablicą');
        }
    }

    private function throw_exception_if_options_are_empty($options) {
        if (empty($options)) {
            throw new Exception('Argument $options nie może byc pusty');
        }
    }

    private function prepare_options($options) {
        $return = array();
        foreach ($options as $option) {
            $group_name_length = strlen($this->group_name);
            $name = substr($option->name, $group_name_length + 1);
            $return[$name] = $option;
        }
        return $return;
    }

    public function __get($name) {
        $option = $this->try_get_option($name);
        return $option->value;
    }

    public function __set($name, $value) {
        $option = $this->try_get_option($name);
        $option->value = $value;
    }

    private function try_get_option($name) {
        if ($this->offsetExists($name))
            return $this->options[strtolower($name)];
        else {
            throw new Exception('Nie istnieje opcja:"' . $name . '" w grupie: ' . $this->group_name);
        }
    }

    public function from_array($array) {
        foreach ($this->options as $key => $option) {
            try {
                $option->value = $array[$key];
            } catch (Exception $e) {
                
            }
        }
    }

    public function as_array() {
        $array = array();
        foreach ($this->options as $key => $option) {
            try {
                $array[$key] = $option->value;
            } catch (Exception $e) {

            }
        }
        return $array;
    }

    public function save() {
        foreach ($this->options as $option) {
            $option->save();
        }
        return TRUE;
    }

    ////////////Araay implementation

    /**
     * mapuje getOffset na standardowy __get
     * @param mixed $offset offset in register
     * @return mixed zwraca pod zadanym offsetem
     */
    public function offsetGet($offset) {
        return $this->__get($offset);
    }

    /**
     * mapuje setOffset na standardowy __set
     * @param mixed $offset offset in request
     * @param mixed $value wartosc do ustawienia
     */
    public function offsetSet($offset, $value) {
        return $this->__set($offset, $value);
    }

    public function offsetUnset($offset) {
        throw new Exception('Opcji nie wolno usuwać.');
    }

    public function offsetExists($offset) {
        return array_key_exists(strtolower($offset), $this->options);
    }

}

?>
