<?php

defined('SYSPATH') or die('No direct script access.');
 //require_once dirname(__FILE__) . '/../classes/model/option/ORM';
abstract class Option {

    private static $option_groups = array();
    private static $group_name = NULL;

    public static function factory($group_name) {
	$group_name = strtolower($group_name);
	if (!isset(self::$option_groups[$group_name])) {
	    self::$group_name = $group_name;
	    $group = new Option_Group(self::$group_name, self::get_options());
	    self::$option_groups[$group_name] = $group;
	}
	return self::$option_groups[$group_name];
    }

    private static function get_options() {
	$options = array();
	try {
	    $options = self::get_options_from_database();
	} catch (Exception $e) {
	    self::make_database_options_from_config();
	    $options = self::get_options_from_database();
	}
	return $options;
    }

    private static function make_database_options_from_config() {
	$config_options = self::get_options_from_config();
	foreach ($config_options as $key => $option) {
	    $option_orm = ORM::factory('option_ORM');
	    $option_orm->name = self::$group_name . '_' . strtolower($key);
	    $option_orm->value = $option;
	    $option_orm->save();
	}
    }

    private static function get_options_from_config() {
	$options = Kohana::config('option.' . self::$group_name);
	if (is_null($options)) {
	    throw new Exception('Brak grupy opcji o nazwie: ' . self::$group_name);
	}
	return $options;
    }

    private static function get_options_from_database() {
	$options = ORM::factory('option_ORM')
			->where('name', 'LIKE', self::$group_name . '_%')
			->find_all();
	self::throw_exception_if_options_empty($options);
	return $options->as_array();
    }

    private static function throw_exception_if_options_empty($options) {
	$options = $options->as_array();
	if (empty($options)) {
	    throw new Exception('Brak danych w bazie dla grupy o nazwie: ' . self::$group_name);
	}
    }

}
?>
