<?php

class Images_Engine_Files_Generator {
    
    const DIR_MEDIA = 'media';
    const PREFIX = 'files_';
    const IMAGES_CONFIG_PATH = 'application/config/images.php';
    private static $exclude = array('.', '..', '.svn', 'tiny_mce', 'jquery', 'upload', 'min');

    public static function get_images_from_media() {
        $files = self::get_directory_content(DOCROOT . self::DIR_MEDIA);
        $images = self::prepare_array_to_save($files);
        self::save_config_file(var_export($images, true));
    }

    private static function get_directory_content($dir) {
        $files = array();
        if (is_dir($dir)) {
            if ($dh = opendir($dir)) {
                while (($dir_file = readdir($dh)) !== false) {
                    if (array_search($dir_file, self::$exclude) === false) {
                        if (is_dir($dir . '/' . $dir_file)) {
                            $tmp_files = self::get_directory_content($dir . '/' . $dir_file);
                            $files = array_merge($files, $tmp_files);
                        } elseif (is_file($dir . '/' . $dir_file)) {
                            $info = getimagesize($dir . '/' . $dir_file);
                            if ($info !== false) {
                                $files[] = array(
                                    'dir' => str_replace(DOCROOT, '', $dir).'/',
                                    'file' => $dir_file,
                                    'attributes' => array(
                                        'alt' => '',
                                        'title' => '',
                                        'width' => $info[0],
                                        'height' => $info[1]
                                    )
                                );
                            }
                        }
                    }
                }
                closedir($dh);
            }
        }
        return $files;
    }

    private static function prepare_array_to_save($files_array) {
        $images = array();
        foreach ($files_array as $file) {
            $suffix = '';
            if(isset($images[self::PREFIX.$file['file']])) {
                $suffix = 1;
                do {
                    $suffix++;
                } while(isset($images[self::PREFIX.$suffix.'_'.$file['file']]));
                $suffix .= '_';
            }
            $images[self::PREFIX.$suffix.$file['file']] = $file;
        }
        return $images;
    }

    private static function save_config_file($files_string) {
        $handle = fopen(DOCROOT . '/' . self::IMAGES_CONFIG_PATH, 'w');
        fwrite($handle, "<?php defined('SYSPATH') or die('No direct script access.');\n\n");
        fwrite($handle, "return \n");
        fwrite($handle, $files_string);
        fwrite($handle, ";\n");
        fclose($handle);
    }

}
?>
