<?php

class Images {

    private $cache_html = array();
    private $engines = array();

    public function __get($name) {
        $engine = $this->get_engine_name($name);
        if(!isset($this->cache_html[$name])) {
            if(!isset($this->engines[$engine])){
                $this->engines[$engine] = Images_Engine::factory($engine);
            }
            $this->cache_html[$name] = $this->engines[$engine]->get_image($name);
        }
        return $this->cache_html[$name];
    }

    private function get_engine_name($name) {
        $engine = preg_replace('/_.*/', '', $name);
        return $engine;
    }

}

?>
