<?php

defined('SYSPATH') or die('No direct script access.');

class Email_Sender {

    private $recipients;
    private $message;
    private $failures = array();

    public function __construct($message, array $recipients) {
        $this->throwExceptionIfRecipientsEmpty($recipients);
        $this->recipients = $recipients;
        $this->message = $message->render();
    }

    private function throwExceptionIfRecipientsEmpty($recipients) {
        if (empty($recipients)) {
            throw new Mailer_Exception('Brak użytkowników');
        }
    }

    public function send() {
        $mailer = $this->getMailer();
        $this->message->setTo($this->recipients);
        $sendResult = $mailer->batchSend($this->message, $this->failures);
        if ($sendResult === FALSE) {
            throw new Mailer_Exception('Źle ustawione opcje');
        } else {
            $emailsTo = array_diff($this->recipients, $this->failures);
            return $emailsTo;
        }
    }

    private function getMailer() {
        return Email::connect();
    }

}

?>