<?php

defined('SYSPATH') or die('No direct script access.');

class Email_Message {

    private $title;
    private $body;
    private $from_mail;
    private $from_label;
    private $replay_email;

    public function __construct($title, $body, $from_mail, $from_label= NULL, $replay_email = '') {

        $this->title = $title;
        $this->body = $body;
        $this->from_mail = $from_mail;
        $this->from_label = $from_label;
        $this->replay_email = $replay_email;
    }

    public function render() {
        $swift_message = new Swift_Message();
        $swift_message->setCharset('utf-8');
        //$swift_message = Swift_Message::newInstance()->setCharset('utf-8');
        $swift_message->setSubject($this->title);
        $swift_message->setBody($this->body, 'text/html');
        $swift_message->setFrom($this->getFrom());
        if (!empty($this->replay_email)) {
            $swift_message->setReplyTo($this->replay_email);
        }
        $swift_message->addPart(html2text::convert($this->body), 'text/plain');
        return $swift_message;
    }

    private function getFrom() {
        if (empty($this->from_label)) {
            return $this->from_mail;
        } else {
            return array($this->from_mail => $this->from_label);
        }
    }

}

?>
