<?php defined('SYSPATH') or die('No direct script access.');

class Kohana_Captcha {

    private static $instance = NULL;

    private $font;
    private $width;
    private $height;
    private $characters;

    public static function instance() {
        if (self::$instance == NULL) {
            self::$instance = new self;
        }
        return self::$instance;
    }

    public function render($html = TRUE) {
        if ($html) {
            return HTML::image(URL::base() . 'captcha', array('style' => 'padding: 1px; border: 1px solid #CCCCCC', 'alt' => 'Captcha'));
        }
        $this->render_image();
    }

    private function init() {
        $config_values = Kohana_Config::instance()->load('captcha');
        $this->width = $config_values['width'];
        $this->height = $config_values['height'];
        $this->characters = $config_values['characters'];
        $this->font = Kohana::find_file('vendor', 'monofont', 'ttf');
    }

    public function render_image() {
        $this->init();
        $code = UTF8::generate_random_string($this->characters); //$this->generate_code();
        $font_size = $this->height * 0.9;
        $image = @imagecreate($this->width, $this->height) or die('Cannot initialize new GD image stream');
        $background_color = imagecolorallocate($image, 255, 255, 255);
        $text_color = imagecolorallocate($image, 126, 126, 126);
        $noise_color = imagecolorallocate($image, 156, 156, 156);
        for ($i = 0; $i < ($this->width * $this->height) / 4; $i++) {
            imagefilledellipse($image, mt_rand(0, $this->width), mt_rand(0, $this->height), 1, 1, $noise_color);
        }
        for ($i = 0; $i < ($this->width * $this->height) / 150; $i++) {
            imageline($image, mt_rand(0, $this->width), mt_rand(0, $this->height), mt_rand(0, $this->width), mt_rand(0, $this->height), $noise_color);
        }
        $letter_box_width = ceil($this->width / $this->characters);
        $letter_box_height = $this->height;
        for ($i=0; $i<$this->characters; $i++) {
            $font_size = $this->height * 0.9;
            $angle = rand(0, 30) - 15;
            do {
                $textbox = imagettfbbox($font_size, $angle, $this->font, substr($code, $i, 1));
                $x_start = min(array($textbox[0], $textbox[2]));
                $y_start = min(array($textbox[1], $textbox[3]));
                $x_end = max(array($textbox[4], $textbox[6]));
                $y_end = max(array($textbox[5], $textbox[7]));
                $width = $x_end - $x_start;
                $height = $y_end - $y_start;
                $font_size = $font_size * 0.9;
            } while ($width > $letter_box_width or $height > $letter_box_height);
            imagettftext($image, $font_size, $angle, ($i * $letter_box_width), (($letter_box_height - $height) / 2), $text_color, $this->font, substr($code, $i, 1));
        }
        ob_clean();
        header('Content-Type: image/jpeg');
        imagejpeg($image);
        imagedestroy($image);
        Kohana_Session::instance()->set('captcha_security_code', $code);
    }

    public static function validate($value) {
        return (bool) ($value === Kohana_Session::instance()->get('captcha_security_code'));
    }

}
?>