<?php

/**
 * $Id: SessionAuthenticator.php 642 2009-01-19 13:49:06Z spocke $
 *
 * @package TinyAuthenticator
 * @author Andrzej Skupien
 * @copyright Copyright � 2007,
 */

/**
 * This class handles MCImageManager SessionAuthenticator stuff.
 *
 * @package SessionAuthenticator
 */
class Moxiecode_TinyAuthenticator extends Moxiecode_ManagerPlugin {
    /*     * #@+
     * @access public
     */

    /**
     * Gets called on a authenication request. This method should check sessions or simmilar to
     * verify that the user has access to the backend.
     *
     * This method should return true if the current request is authenicated or false if it's not.
     *
     * @param ManagerEngine $man ManagerEngine reference that the plugin is assigned to.
     * @return bool true/false if the user is authenticated.
     */
    function onAuthenticate(&$man) {
	return simpleauth::instance()->logged_in();
    }

}

// Add plugin to MCManager
$man->registerPlugin("TinyAuthenticator", new Moxiecode_TinyAuthenticator());
?>
