<?php

/**
 *
 * Backup bazy danych POROSA
 *
 */

set_time_limit(6000);

define('SUPPRESS_REQUEST', 1);

$_SERVER = array(
    'HTTP_USER_AGENT' => '',
    'HTTP_HOST' => 'www.a-tech.pl',
    'SERVER_NAME' => 'www.a-tech.pl',
    'SERVER_ADDR' => '127.0.0.1'
);
require_once 'porosa.pl/index.php';

class backup {

    const PROJECT_NAME = 'Porosa';

    private $backup_dir = NULL;
    private $gz_enable = FALSE;
    private $file = NULL;
    private $db = NULL;
    private $prefix = NULL;
    private $db_constraints = '';

    public function __construct() {
        $this->backup_dir = $this->prepare_directory();
        $this->gz_enable = function_exists('gzopen');
        $this->prefix = Database::instance()->table_prefix();
    }

    public function prepare_directory() {
        if (!file_exists(dirname(__FILE__) . '/backup-mysql')) {
            mkdir(dirname(__FILE__) . '/backup-mysql');
        }
        if (!file_exists(dirname(__FILE__) . '/backup-mysql/.htaccess')) {
                $htaccess = fopen(dirname(__FILE__) . '/backup-mysql/.htaccess', 'w');
                fwrite($htaccess, "RewriteEngine On\n\n" .
                                                        "RewriteRule .* - [F]");
                fclose($htaccess);
        }
        return dirname(__FILE__) . '/backup-mysql/';
    }

    public function create_backup() {
        $this->open_file();
        $this->save_db_to_file();
        $this->close_file();
    }

    private function open_file() {
        if(file_exists($this->backup_dir . 'backup-' . self::PROJECT_NAME . '-d' . date('d') . '-h' . date('H') . '.sql' . ($this->gz_enable ? '.gz' : ''))) {
                @unlink ($this->backup_dir . 'backup-' . self::PROJECT_NAME . '-d' . date('d') . '-h' . date('H') . '.sql' . ($this->gz_enable ? '.gz' : ''));
        }
        $this->file = (
                $this->gz_enable ?
                gzopen($this->backup_dir . 'backup-'  . self::PROJECT_NAME . '-d' . date('d') . '-h' . date('H') . '.sql.gz', 'w') :
                fopen($this->backup_dir . 'backup-'  . self::PROJECT_NAME . '-d' . date('d') . '-h' . date('H') . '.sql', 'w')
        );
    }

    private function close_file() {
        ($this->gz_enable ? gzclose($this->file) : fclose($this->file));
    }

    private function save_to_file($content) {
        ($this->gz_enable ? gzwrite($this->file, $content) : fwrite($this->file, $content));
    }

    private function save_db_to_file() {
        $tables = Database::instance()->list_tables();
        if (!empty($tables)) {
            foreach ($tables as $table) {
                if (preg_match('/^' . $this->prefix . '/', $table)) {
                    $this->mysqldump_table_structure($table);
                    $this->mysqldump_table_data($table);
                    if ($this->db_constraints != '') {
                        $this->save_to_file($this->db_constraints);
                    }
                }
            }
        } else {
            $this->save_to_file("/* no tables in database */\n");
        }
    }

    private function mysqldump_table_structure($table) {
        $this->save_to_file("/* Table structure for table `$table` */\n" .
                "DROP TABLE IF EXISTS `$table`;\n\n");
        $row = DB::query(
                Database::SELECT,
                "show create table `$table`; "
                )->execute()->current();
        if ($row) {
            if (isset($row['Create Table'])) {
                $create = $row['Create Table'];
                if (preg_match('/CONSTRAINT/', $create)) {
                    preg_match_all('/CONSTRAINT.*/', $create, $table_constraints);
                    foreach ($table_constraints[0] as $item) {
                        $create = str_replace($item, '', $create);
                        $create = preg_replace('/,[\s]+\)/', "\n) ", $create);
                        $this->db_constraints .= "\n\n" . 'ALTER TABLE `' . $table . '` ADD ' . str_replace(',', '', $item) . ';';
                    }
                }
                $this->save_to_file($create . ";\n\n");
            }
        }
    }

    private function mysqldump_table_data($table) {
        $ln = 0;
        $num_result = DB::query(
                Database::SELECT,
                "Select count(*) as rows_num FROM `$table`;"
                )->execute()->get('rows_num');
        if ($num_result) {
            $total_rows = $num_result;
            $start_row = 0;
            $limit = 200;
            $this->save_to_file("/* dumping data for table `$table` */\n");
            do {
                $result = DB::query(
                        Database::SELECT,
                        "Select * From `$table` limit $start_row, $limit;"
                        )->execute();
                if ($result) {
                    $num_rows = $result->count();
                    $fields = Database::instance()->list_columns(preg_replace('/^'.$this->prefix.'/', '', $table));
                    $num_fields = count($fields);
                    if ($num_rows > 0) {
                        $field_type = array();
                        $i = 0;
                        foreach ($fields as $field_name => $field) {
                            $field_type[$field_name] = $field['type'];
                        }
                        $insert_rows = "insert into `$table` values\n";
                        $index = 0;
                        foreach ($result as $row) {
                            $ln++;
                            $insert_rows .= "(";
                            $i = 0;
                            foreach ($row as $field_name => $field_value) {
                                if (is_null($field_value))
                                    $insert_rows .= "null";
                                else {
                                    switch ($field_type[$field_name]) {
                                        case 'int':
                                            $insert_rows .= $field_value;
                                            break;
                                        case 'string':
                                        case 'blob' :
                                        default:
                                            $insert_rows .= "'" . mysql_real_escape_string($field_value) . "'";
                                    }
                                }
                                if (++$i < $num_fields)
                                    $insert_rows .= ",";
                            }
                            $insert_rows .= ")";

                            if ($index < $num_rows - 1) {
                                if ($ln % 200 == 0) {
                                    $insert_rows .= ";\n";
                                    $this->save_to_file($insert_rows);
                                    $insert_rows = "insert into `$table` values";
                                }
                                else
                                    $insert_rows .= ",";
                            }
                            else {
                                $insert_rows .= ";";
                            }
                            $insert_rows .= "\n";

                            $index++;
                        }
                        if ($insert_rows != '') {
                            $this->save_to_file($insert_rows . "\n\n");
                            $insert_rows = '';
                        }
                    }
                }
                $start_row += $limit;
            } while ($start_row < $total_rows);
            $this->save_to_file("\n");
        }
    }

}

$bck = new backup();
$bck->create_backup();

?>