<?php defined('SYSPATH') or die('No direct script access.'); ?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <title><?php echo $title; ?></title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <meta name="KeyWords" content="<?php echo $keywords; ?>" />
        <meta name="Description" content="<?php echo $description; ?>" />
        <meta name="robots" content="all" />
        <meta name="Language" content="pl" />

        <?php echo html::style(URL::base() . 'media/min/?g=front_css'); ?>
    </head>
    <body>
        <div id="body-all">
            <div class="body-content">
                <div id="header">
                    <div id="header-languages">
                        <?php
                        echo HTML::anchor(
                                URL::base() . 'language,1', 'Polski', array('class' => 'language language_pl')
                        );
                        ?>
                        <?php
                        echo HTML::anchor(
                                URL::base() . 'language,2', 'English', array('class' => 'language language_en')
                        );
                        ?>
                    </div>
                    <div id="header-logo">
                        <h1>
                            <a id="first_name" href="/"><?php echo html::image(URL::base() . 'media/images/materna&ossowska.jpg', array('alt' => 'Materna & Ossowska')); ?></a><br />
                            <a id="second_name" href="/"><?php echo $translations->HEAD_SITE_NAME; ?></a>
                        </h1>
                    </div>
                </div>
            </div>
            <div id="header-menu">
                <div class="body-content">
                    <div class="clear"></div>
                    <table cellspacing="0" cellpadding="0" align="center"><tr><td>
                        <ul class="main">
                            <li class="<?php echo (Kohana_Request::instance()->controller == 'main' ? 'selected' : ''); ?>" >
                                <span class="top_arrow">&nbsp;</span>
                                <?php echo HTML::anchor(URL::base(), UTF8::strtoupper($translations->LABEL_main_site)); ?>
                            </li>
                            <?php foreach ($menu_top as $site): ?>
                                <li class="<?php echo (Kohana_Request::instance()->param('id') == $site['id'] ? 'selected' : ''); ?>" >
                                    <span class="top_arrow">&nbsp;</span>
                                    <?php echo HTML::anchor(URL::base() . $site['content_id'] . '.' . UTF8::user_friendly($site['name']) . '.html', UTF8::strtoupper($site['name'])); ?>
                                    <?php if (isset($site['sub'])): ?>
                                        <ul>
                                            <?php foreach ($site['sub'] as $subsite): ?>
                                                <li>
                                                    <?php echo HTML::anchor(URL::base() . $subsite['content_id'] . '.' . UTF8::user_friendly($subsite['name']) . '.html', UTF8::strtoupper($subsite['name'])); ?>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    <?php endif; ?>
                                </li>
                            <?php endforeach; ?>
                            <li class="<?php echo (Kohana_Request::instance()->controller == 'contact' ? 'selected' : ''); ?>" >
                                <span class="top_arrow">&nbsp;</span>
                                <?php echo HTML::anchor(URL::base() . 'contact', UTF8::strtoupper($translations->LABEL_KONTAKT)); ?>
                            </li>
                        </ul>
                    </td></tr></table>
                </div>
            </div>
            <div id="background">
                <?php echo $content; ?>
                <div class="clear"></div>
                <div id="footer">
                    <div id="footer-content">
                        <div class="left">&copy; Copyright by <a href="http://www.materna-ossowska.pl">www.materna-ossowska.pl</a> <?php echo date('Y'); ?>. <?php echo $translations->LABEL_all_rights_reserved; ?>.</div>
                        <div class="right"><?php echo $translations->LABEL_created_by; ?> <a href="http://www.a-tech.pl" target="_blank"><b>a-tech.pl</b></a></div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo HTML::script('media/min/?g=front_js', array('charset' => 'utf-8')); ?>
        <script type="text/javascript">

              var _gaq = _gaq || [];
              _gaq.push(['_setAccount', 'UA-17885943-14']);
              _gaq.push(['_trackPageview']);

              (function() {
                var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
                ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
                var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
              })();

        </script>

    </body>
</html>