/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50508
Source Host           : localhost:3306
Source Database       : kancelaria

Target Server Type    : MYSQL
Target Server Version : 50508
File Encoding         : 65001

Date: 2012-02-24 10:13:27
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `kanc__auth_rights`
-- ----------------------------
DROP TABLE IF EXISTS `kanc__auth_rights`;
CREATE TABLE `kanc__auth_rights` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_polish_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci;

-- ----------------------------
-- Records of kanc__auth_rights
-- ----------------------------
INSERT INTO `kanc__auth_rights` VALUES ('1', 'access');
INSERT INTO `kanc__auth_rights` VALUES ('2', 'menu.admin.view');
INSERT INTO `kanc__auth_rights` VALUES ('3', 'menu.admin.access');
INSERT INTO `kanc__auth_rights` VALUES ('4', 'controller.admin.site.access');
INSERT INTO `kanc__auth_rights` VALUES ('5', 'controller.edit');
INSERT INTO `kanc__auth_rights` VALUES ('6', 'logout');
INSERT INTO `kanc__auth_rights` VALUES ('7', 'controller.admin.user.access');
INSERT INTO `kanc__auth_rights` VALUES ('8', 'controller.admin.user.change_password');
INSERT INTO `kanc__auth_rights` VALUES ('9', 'menu.admin.user.user.view');
INSERT INTO `kanc__auth_rights` VALUES ('10', 'menu.admin.user.user/change_password.view');

-- ----------------------------
-- Table structure for `kanc__auth_users`
-- ----------------------------
DROP TABLE IF EXISTS `kanc__auth_users`;
CREATE TABLE `kanc__auth_users` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(127) COLLATE utf8_polish_ci NOT NULL,
  `username` varchar(32) COLLATE utf8_polish_ci NOT NULL DEFAULT '',
  `password` char(50) COLLATE utf8_polish_ci NOT NULL,
  `role` int(11) NOT NULL DEFAULT '4',
  `logins` int(10) unsigned NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `active_to` datetime DEFAULT NULL,
  `ip_address` varchar(15) COLLATE utf8_polish_ci DEFAULT NULL,
  `last_ip_address` varchar(15) COLLATE utf8_polish_ci DEFAULT NULL,
  `time_stamp` datetime DEFAULT NULL,
  `last_time_stamp` datetime DEFAULT NULL,
  `time_stamp_created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci;

-- ----------------------------
-- Records of kanc__auth_users
-- ----------------------------
INSERT INTO `kanc__auth_users` VALUES ('1', 'a-tech', 'a-tech', '2f07cbc04b24efae50c6bf30e92ee7e866dc213e', '3', '104', '1', null, '127.0.0.1', '127.0.0.1', '2010-10-12 13:57:52', '2010-10-12 13:57:52', null);
INSERT INTO `kanc__auth_users` VALUES ('2', 'admin', 'admin', '14ec56c395b7950392b894e608ece41ba85b5fc9', '2', '109', '1', null, '127.0.0.1', '127.0.0.1', '2010-12-20 13:10:03', '2010-12-20 13:10:03', '2010-12-20 12:43:09');

-- ----------------------------
-- Table structure for `kanc__auth_user_roles`
-- ----------------------------
DROP TABLE IF EXISTS `kanc__auth_user_roles`;
CREATE TABLE `kanc__auth_user_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) COLLATE utf8_polish_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci;

-- ----------------------------
-- Records of kanc__auth_user_roles
-- ----------------------------
INSERT INTO `kanc__auth_user_roles` VALUES ('1', 'admin');
INSERT INTO `kanc__auth_user_roles` VALUES ('2', 'atech');
INSERT INTO `kanc__auth_user_roles` VALUES ('3', 'moderator');

-- ----------------------------
-- Table structure for `kanc__auth_user_role_has_auth_rights`
-- ----------------------------
DROP TABLE IF EXISTS `kanc__auth_user_role_has_auth_rights`;
CREATE TABLE `kanc__auth_user_role_has_auth_rights` (
  `auth_user_role_id` int(11) NOT NULL,
  `auth_rights_id` int(11) NOT NULL,
  `rights` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`auth_user_role_id`,`auth_rights_id`),
  KEY `fk_user_role_has_rights_rights1` (`auth_rights_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci;

-- ----------------------------
-- Records of kanc__auth_user_role_has_auth_rights
-- ----------------------------
INSERT INTO `kanc__auth_user_role_has_auth_rights` VALUES ('0', '1', '1');
INSERT INTO `kanc__auth_user_role_has_auth_rights` VALUES ('0', '2', '1');
INSERT INTO `kanc__auth_user_role_has_auth_rights` VALUES ('1', '2', '1');
INSERT INTO `kanc__auth_user_role_has_auth_rights` VALUES ('1', '3', '1');
INSERT INTO `kanc__auth_user_role_has_auth_rights` VALUES ('2', '2', '1');
INSERT INTO `kanc__auth_user_role_has_auth_rights` VALUES ('2', '3', '1');
INSERT INTO `kanc__auth_user_role_has_auth_rights` VALUES ('1', '4', '1');
INSERT INTO `kanc__auth_user_role_has_auth_rights` VALUES ('2', '4', '1');
INSERT INTO `kanc__auth_user_role_has_auth_rights` VALUES ('1', '5', '1');
INSERT INTO `kanc__auth_user_role_has_auth_rights` VALUES ('2', '5', '1');
INSERT INTO `kanc__auth_user_role_has_auth_rights` VALUES ('0', '26', '1');
INSERT INTO `kanc__auth_user_role_has_auth_rights` VALUES ('3', '7', '0');
INSERT INTO `kanc__auth_user_role_has_auth_rights` VALUES ('3', '8', '1');
INSERT INTO `kanc__auth_user_role_has_auth_rights` VALUES ('3', '9', '0');
INSERT INTO `kanc__auth_user_role_has_auth_rights` VALUES ('3', '10', '1');
INSERT INTO `kanc__auth_user_role_has_auth_rights` VALUES ('1', '8', '1');

-- ----------------------------
-- Table structure for `kanc__auth_user_tokens`
-- ----------------------------
DROP TABLE IF EXISTS `kanc__auth_user_tokens`;
CREATE TABLE `kanc__auth_user_tokens` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned NOT NULL,
  `user_agent` varchar(40) COLLATE utf8_polish_ci NOT NULL,
  `token` varchar(32) COLLATE utf8_polish_ci NOT NULL,
  `time_stamp_created` datetime DEFAULT NULL,
  `expires` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci;

-- ----------------------------
-- Records of kanc__auth_user_tokens
-- ----------------------------

-- ----------------------------
-- Table structure for `kanc__content`
-- ----------------------------
DROP TABLE IF EXISTS `kanc__content`;
CREATE TABLE `kanc__content` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_parent` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL,
  `meta_title` varchar(512) COLLATE utf8_polish_ci NOT NULL,
  `meta_description` varchar(512) COLLATE utf8_polish_ci NOT NULL,
  `meta_keywords` varchar(512) COLLATE utf8_polish_ci NOT NULL,
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `date_added` timestamp NULL DEFAULT NULL,
  `sort` int(11) NOT NULL,
  `kind_id` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci;

-- ----------------------------
-- Records of kanc__content
-- ----------------------------
INSERT INTO `kanc__content` VALUES ('1', '0', '1', '', '', '', '2012-02-23 12:43:37', '2012-02-23 12:43:37', '1', '1');
INSERT INTO `kanc__content` VALUES ('2', '0', '1', '', '', '', '2012-02-23 12:44:06', '2012-02-23 12:44:06', '2', '1');
INSERT INTO `kanc__content` VALUES ('3', '0', '1', '', '', '', '2012-02-23 12:44:32', '2012-02-23 12:44:32', '3', '1');
INSERT INTO `kanc__content` VALUES ('4', '0', '1', '', '', '', '2012-02-23 12:44:52', '2012-02-23 12:44:52', '4', '1');

-- ----------------------------
-- Table structure for `kanc__content_kind`
-- ----------------------------
DROP TABLE IF EXISTS `kanc__content_kind`;
CREATE TABLE `kanc__content_kind` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_polish_ci NOT NULL,
  `human_name` varchar(255) COLLATE utf8_polish_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci;

-- ----------------------------
-- Records of kanc__content_kind
-- ----------------------------
INSERT INTO `kanc__content_kind` VALUES ('1', 'Site', 'Strona');
INSERT INTO `kanc__content_kind` VALUES ('2', 'Partner', 'Partner');
INSERT INTO `kanc__content_kind` VALUES ('3', 'Site_Media_Image', 'Artykuły');
INSERT INTO `kanc__content_kind` VALUES ('4', 'Site_Middle', 'Strona Menu Środkowego');

-- ----------------------------
-- Table structure for `kanc__content_sites`
-- ----------------------------
DROP TABLE IF EXISTS `kanc__content_sites`;
CREATE TABLE `kanc__content_sites` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `content_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `tabs_variant` int(11) NOT NULL DEFAULT '1',
  `name` varchar(512) NOT NULL,
  `meta_title` varchar(512) NOT NULL,
  `meta_description` varchar(512) NOT NULL,
  `meta_keywords` varchar(512) NOT NULL,
  `body` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kanc__content_sites
-- ----------------------------
INSERT INTO `kanc__content_sites` VALUES ('1', '1', '1', '1', 'KANCELARIA', 'KANCELARIA', 'KANCELARIA', 'KANCELARIA', '<p>Indywidualne podejście.............</p>\n<p>.........</p>\n<p>Zapraszamy do skorzystania z naszych usług.</p>\n<p> </p>\n<div style=\"width: 465px; margin: 0px auto;\">\n<table border=\"0\">\n<tbody>\n<tr>\n<td>\n<table border=\"0\">\n<tbody>\n<tr style=\"vertical-align: top;\">\n<td><img src=\"../../../media/photos/k.materna.jpg\" alt=\"k.materna\" width=\"85\" height=\"119\" /></td>\n<td>\n<div style=\"margin-left: 5px;\">\n<p><span style=\"font-size: 12px; color: #971a18;\"><strong> Katarzyna Materna</strong></span><br /> radca prawny/ partner</p>\n<div style=\"margin: 7px 0 0 8px;\">\n<p>» prawo administarcyjne<br /> » prawo handlowe<br /> » prawo podatkowe<br /> » prawo spadkowe<br /> » prawo pracy</p>\n</div>\n</div>\n</td>\n</tr>\n<tr>\n<td colspan=\"2\">\n<p>kontakt:<br /><a href=\"mailto:k.materna@materna-ossowska.pl\">k.materna@materna-ossowska.pl</a></p>\n</td>\n</tr>\n</tbody>\n</table>\n</td>\n<td>\n<table border=\"0\">\n<tbody>\n<tr style=\"vertical-align: top;\">\n<td><img src=\"../../../media/photos/a.ossowska.jpg\" alt=\"a.ossowska\" width=\"85\" height=\"119\" /><br /></td>\n<td>\n<div style=\"margin-left: 5px;\">\n<p><span style=\"font-size: 12px; color: #971a18;\"><strong> Anna Ossowska</strong></span><br /> radca prawny/ partner</p>\n<div style=\"margin: 7px 0 0 8px;\">\n<p>» prawo cywilne<br /> » prawo rodzinne<br /> » prawo handlowe<br /> » prawo bankowe<br /> » prawo autorskie</p>\n</div>\n</div>\n</td>\n</tr>\n<tr>\n<td colspan=\"2\">\n<p>kontakt:<br /><a href=\"mailto:a.ossowska@materna-ossowska.pl\">a.ossowska@materna-ossowska.pl</a></p>\n</td>\n</tr>\n</tbody>\n</table>\n</td>\n</tr>\n<tr>\n<td colspan=\"2\">\n<div style=\"width: 175px; margin: 0px auto;\">\n<table border=\"0\">\n<tbody>\n<tr style=\"vertical-align: top;\">\n<td><img src=\"../../../media/photos/i.rybka.png\" alt=\"i.rybka\" width=\"85\" height=\"119\" /><br /></td>\n<td>\n<div style=\"margin-left: 5px;\">\n<p><span style=\"font-size: 12px; color: #971a18;\"><strong> Iliana Rybka</strong></span><br /> asystent</p>\n</div>\n</td>\n</tr>\n<tr>\n<td colspan=\"2\">\n<p>kontakt:<br /><a href=\"mailto:i.rybka@materna-ossowska.pl\">i.rybka@materna-ossowska.pl</a></p>\n</td>\n</tr>\n</tbody>\n</table>\n</div>\n</td>\n</tr>\n</tbody>\n</table>\n</div>');
INSERT INTO `kanc__content_sites` VALUES ('2', '1', '2', '1', 'KANCELARIA', 'KANCELARIA', 'KANCELARIA', 'KANCELARIA', '<p>Vestibulum sit amet euismod metus. Sed ut fringilla dui. Mauris semper eros quis ante tempus ac accumsan velit tristique? Aliquam erat volutpat. Donec ut lacus et dui sollicitudin cursus in id magna. Morbi lobortis nisl id nulla aliquet convallis. Nulla porta dui sit amet sem lacinia sit amet scelerisque risus eleifend. Praesent at augue non ligula lobortis blandit. Aenean varius nibh quis elit imperdiet vel aliquet diam euismod? Nulla quis lectus lacus, sed posuere lacus.</p>\n<p>Cras et turpis ut purus eleifend accumsan. Sed tempor molestie risus ut suscipit. Nullam sed risus orci. Duis scelerisque vehicula velit vel venenatis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed bibendum magna euismod elit elementum aliquam? Morbi tincidunt lacus nec orci laoreet in semper quam varius. Donec et nisi nibh. Pellentesque convallis, odio et egestas pretium, lacus nulla semper ipsum, eget consectetur enim justo in nisl. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Donec imperdiet ornare neque non pellentesque.</p>\n<p>Maecenas et diam eu nisl luctus bibendum consectetur sollicitudin tortor. Aliquam nec lacus non arcu tincidunt fringilla. Nullam blandit leo non tellus interdum sollicitudin. Aliquam sagittis rutrum malesuada. Pellentesque mattis lorem urna. In sed felis a turpis mollis luctus. Ut mollis commodo nisl ac tempus. Maecenas dapibus lobortis eros, gravida egestas nibh dapibus sit amet. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Pellentesque suscipit enim non arcu suscipit venenatis. Morbi consectetur dictum felis et sollicitudin. Donec porta; purus at accumsan bibendum, enim erat commodo massa, at consectetur lectus magna eget urna! Ut consequat augue eget mauris adipiscing euismod!</p>');
INSERT INTO `kanc__content_sites` VALUES ('3', '2', '1', '1', 'CENNIK', 'CENNIK', 'CENNIK', 'CENNIK', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Integer nunc libero, semper eget blandit vel, accumsan et diam. Ut velit sapien, tincidunt at ultricies commodo, facilisis a tellus. Vestibulum vitae lectus in leo pretium sagittis. Nulla gravida velit orci, sed imperdiet risus. Cras molestie, leo nec aliquam volutpat, purus nulla egestas turpis, vitae pulvinar nunc augue nec dolor. Sed eget risus at quam pharetra scelerisque. Nulla facilisi. Nunc laoreet sapien id ante gravida in tempor sem iaculis. Praesent arcu arcu, semper a dictum sed, dignissim cursus mauris. Ut eget malesuada felis. Proin quis venenatis magna.</p>\n<p>Vestibulum dapibus tincidunt convallis? Integer non orci massa? Cras vel felis enim. Morbi placerat quam eget neque consequat ac pharetra mi cursus. Sed eu dui turpis, eget feugiat mi. Sed tincidunt mattis ipsum; nec egestas ante sollicitudin eget. Phasellus felis est, pretium vel vulputate quis, feugiat sed nibh? Pellentesque ac sem at mauris venenatis scelerisque. Phasellus dolor justo, porttitor auctor porttitor ut, volutpat at massa. Phasellus ut purus lacus. Praesent tincidunt purus sed augue laoreet convallis? Nunc placerat nulla ac elit viverra gravida. Suspendisse et nisl eros. Suspendisse libero velit; sagittis eu accumsan ac, euismod quis velit. Quisque sollicitudin elit a odio ultrices accumsan. Ut id tortor vel neque lobortis ornare id id nisl.</p>\n<p>Maecenas cursus enim purus, eu rutrum libero? Nulla enim libero, pulvinar in vehicula a, tempor sed orci. Aliquam in ante nibh, at blandit tellus. Vestibulum dui nunc, suscipit at mollis in, aliquet egestas sem. Aenean mattis dignissim arcu eu pulvinar. Nunc vel sem a nisl dapibus ultricies vel vitae velit. Curabitur eu erat luctus orci pretium cursus et non lectus!</p>');
INSERT INTO `kanc__content_sites` VALUES ('4', '2', '2', '1', 'CENNIK', 'CENNIK', 'CENNIK', 'CENNIK', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Integer nunc libero, semper eget blandit vel, accumsan et diam. Ut velit sapien, tincidunt at ultricies commodo, facilisis a tellus. Vestibulum vitae lectus in leo pretium sagittis. Nulla gravida velit orci, sed imperdiet risus. Cras molestie, leo nec aliquam volutpat, purus nulla egestas turpis, vitae pulvinar nunc augue nec dolor. Sed eget risus at quam pharetra scelerisque. Nulla facilisi. Nunc laoreet sapien id ante gravida in tempor sem iaculis. Praesent arcu arcu, semper a dictum sed, dignissim cursus mauris. Ut eget malesuada felis. Proin quis venenatis magna.</p>\n<p>Vestibulum dapibus tincidunt convallis? Integer non orci massa? Cras vel felis enim. Morbi placerat quam eget neque consequat ac pharetra mi cursus. Sed eu dui turpis, eget feugiat mi. Sed tincidunt mattis ipsum; nec egestas ante sollicitudin eget. Phasellus felis est, pretium vel vulputate quis, feugiat sed nibh? Pellentesque ac sem at mauris venenatis scelerisque. Phasellus dolor justo, porttitor auctor porttitor ut, volutpat at massa. Phasellus ut purus lacus. Praesent tincidunt purus sed augue laoreet convallis? Nunc placerat nulla ac elit viverra gravida. Suspendisse et nisl eros. Suspendisse libero velit; sagittis eu accumsan ac, euismod quis velit. Quisque sollicitudin elit a odio ultrices accumsan. Ut id tortor vel neque lobortis ornare id id nisl.</p>\n<p>Maecenas cursus enim purus, eu rutrum libero? Nulla enim libero, pulvinar in vehicula a, tempor sed orci. Aliquam in ante nibh, at blandit tellus. Vestibulum dui nunc, suscipit at mollis in, aliquet egestas sem. Aenean mattis dignissim arcu eu pulvinar. Nunc vel sem a nisl dapibus ultricies vel vitae velit. Curabitur eu erat luctus orci pretium cursus et non lectus!</p>');
INSERT INTO `kanc__content_sites` VALUES ('5', '3', '1', '1', 'KANCELARIA DLA DZIECI', 'KANCELARIA DLA DZIECI', 'KANCELARIA DLA DZIECI', 'KANCELARIA DLA DZIECI', '<p>Maecenas nec est libero, ac auctor ante? Suspendisse vestibulum pretium feugiat. Nam elementum nisi quis metus viverra quis rutrum mi imperdiet. Maecenas dignissim ipsum quis mauris aliquam in semper mauris ultricies. Ut at consequat lorem. Morbi pharetra risus ut turpis fermentum commodo vel sed ipsum. Nulla vestibulum commodo rhoncus. Cras porttitor ante pulvinar quam malesuada imperdiet? Sed ut leo sed sapien fermentum laoreet eget quis leo.</p>\n<p>Nam dui odio, lobortis vitae hendrerit sit amet, sollicitudin sit amet nibh. Nulla vel augue eros. Morbi enim mauris, hendrerit id pretium ac, interdum nec augue. Aliquam erat volutpat. Nullam iaculis elit massa? Suspendisse euismod condimentum ipsum egestas euismod. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Lorem ipsum dolor sit amet, consectetur adipiscing elit. In hac habitasse platea dictumst. Duis eu laoreet ipsum. Aliquam erat volutpat. Sed id lectus vel diam mollis elementum. Cras sagittis placerat dui egestas tincidunt? Vestibulum varius, eros quis adipiscing scelerisque; orci ipsum tincidunt mauris, ac tincidunt leo eros vitae sapien. Duis mollis libero eget neque interdum tincidunt? Maecenas sagittis pulvinar placerat.</p>\n<p>Sed luctus neque quis felis vestibulum a condimentum libero interdum. Duis vel dui tellus. Suspendisse semper turpis in velit suscipit ut mattis lacus placerat. Donec id nisl in turpis pellentesque rhoncus sed ac erat. Vivamus sodales tellus eget lacus rhoncus fermentum. Mauris lectus magna, facilisis quis porttitor quis, malesuada eget odio. Quisque nec felis ut mauris condimentum convallis sit amet vitae nisi. Proin eu tellus nunc? Vivamus quis nibh eros, ac rhoncus sem. Donec tincidunt ultrices mattis. Aenean mattis egestas interdum. Praesent ut iaculis enim.</p>');
INSERT INTO `kanc__content_sites` VALUES ('6', '3', '2', '1', 'KANCELARIA DLA DZIECI', 'KANCELARIA DLA DZIECI', 'KANCELARIA DLA DZIECI', 'KANCELARIA DLA DZIECI', '<p>Maecenas nec est libero, ac auctor ante? Suspendisse vestibulum pretium feugiat. Nam elementum nisi quis metus viverra quis rutrum mi imperdiet. Maecenas dignissim ipsum quis mauris aliquam in semper mauris ultricies. Ut at consequat lorem. Morbi pharetra risus ut turpis fermentum commodo vel sed ipsum. Nulla vestibulum commodo rhoncus. Cras porttitor ante pulvinar quam malesuada imperdiet? Sed ut leo sed sapien fermentum laoreet eget quis leo.</p>\n<p>Nam dui odio, lobortis vitae hendrerit sit amet, sollicitudin sit amet nibh. Nulla vel augue eros. Morbi enim mauris, hendrerit id pretium ac, interdum nec augue. Aliquam erat volutpat. Nullam iaculis elit massa? Suspendisse euismod condimentum ipsum egestas euismod. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Lorem ipsum dolor sit amet, consectetur adipiscing elit. In hac habitasse platea dictumst. Duis eu laoreet ipsum. Aliquam erat volutpat. Sed id lectus vel diam mollis elementum. Cras sagittis placerat dui egestas tincidunt? Vestibulum varius, eros quis adipiscing scelerisque; orci ipsum tincidunt mauris, ac tincidunt leo eros vitae sapien. Duis mollis libero eget neque interdum tincidunt? Maecenas sagittis pulvinar placerat.</p>\n<p>Sed luctus neque quis felis vestibulum a condimentum libero interdum. Duis vel dui tellus. Suspendisse semper turpis in velit suscipit ut mattis lacus placerat. Donec id nisl in turpis pellentesque rhoncus sed ac erat. Vivamus sodales tellus eget lacus rhoncus fermentum. Mauris lectus magna, facilisis quis porttitor quis, malesuada eget odio. Quisque nec felis ut mauris condimentum convallis sit amet vitae nisi. Proin eu tellus nunc? Vivamus quis nibh eros, ac rhoncus sem. Donec tincidunt ultrices mattis. Aenean mattis egestas interdum. Praesent ut iaculis enim.</p>');
INSERT INTO `kanc__content_sites` VALUES ('7', '4', '1', '1', 'DARMOWE WZORY', 'DARMOWE WZORY', 'DARMOWE WZORY', 'DARMOWE WZORY', '<p>Vivamus eros sem, gravida ut laoreet nec, rhoncus ac dui. Nullam condimentum; lectus a fringilla volutpat, elit odio ullamcorper mauris, non sagittis metus turpis eu mi! Integer in ante id nunc adipiscing dictum quis euismod enim. Cras a lorem nec nulla varius facilisis. Nunc eget pellentesque risus. Aenean interdum arcu at ipsum euismod elementum. Aliquam erat volutpat. Curabitur ac nisl leo! Nullam sodales porttitor ligula, sit amet imperdiet risus faucibus ut. Nulla facilisi. Donec posuere sollicitudin justo sit amet sagittis.</p>\n<p>Cras lobortis, lacus in viverra dapibus, augue neque sodales tortor, et sollicitudin nunc mi sit amet libero. Suspendisse potenti. Pellentesque consectetur ligula a diam semper ultrices. Nam elementum metus a mauris ultricies non pulvinar erat aliquam. Suspendisse molestie ultricies volutpat! In laoreet pharetra leo, ut tempus eros ultricies eu. Mauris eu faucibus dolor.</p>\n<p>Aenean ultrices pellentesque elit; vitae luctus massa vehicula ut. Quisque ullamcorper massa non nibh sagittis a ultrices ligula sollicitudin? Nunc ornare neque congue metus hendrerit vitae condimentum purus pretium. Integer nulla nulla, aliquam nec fermentum nec, auctor a velit. Aenean sagittis, leo et elementum malesuada, augue lacus luctus nisi, id placerat turpis quam ac erat. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut eget eros nibh, quis luctus nibh. Nam a metus eu ligula eleifend gravida ut a dolor. Donec et diam metus, convallis dictum erat? Nullam et nisi ut dolor sollicitudin sodales et quis justo. Etiam dapibus purus et diam congue quis faucibus orci ultricies. Nullam dignissim, est in placerat gravida, turpis nibh tincidunt felis, ut suscipit mi mauris imperdiet urna.</p>');
INSERT INTO `kanc__content_sites` VALUES ('8', '4', '2', '1', 'DARMOWE WZORY', 'DARMOWE WZORY', 'DARMOWE WZORY', 'DARMOWE WZORY', '<p>Vivamus eros sem, gravida ut laoreet nec, rhoncus ac dui. Nullam condimentum; lectus a fringilla volutpat, elit odio ullamcorper mauris, non sagittis metus turpis eu mi! Integer in ante id nunc adipiscing dictum quis euismod enim. Cras a lorem nec nulla varius facilisis. Nunc eget pellentesque risus. Aenean interdum arcu at ipsum euismod elementum. Aliquam erat volutpat. Curabitur ac nisl leo! Nullam sodales porttitor ligula, sit amet imperdiet risus faucibus ut. Nulla facilisi. Donec posuere sollicitudin justo sit amet sagittis.</p>\n<p>Cras lobortis, lacus in viverra dapibus, augue neque sodales tortor, et sollicitudin nunc mi sit amet libero. Suspendisse potenti. Pellentesque consectetur ligula a diam semper ultrices. Nam elementum metus a mauris ultricies non pulvinar erat aliquam. Suspendisse molestie ultricies volutpat! In laoreet pharetra leo, ut tempus eros ultricies eu. Mauris eu faucibus dolor.</p>\n<p>Aenean ultrices pellentesque elit; vitae luctus massa vehicula ut. Quisque ullamcorper massa non nibh sagittis a ultrices ligula sollicitudin? Nunc ornare neque congue metus hendrerit vitae condimentum purus pretium. Integer nulla nulla, aliquam nec fermentum nec, auctor a velit. Aenean sagittis, leo et elementum malesuada, augue lacus luctus nisi, id placerat turpis quam ac erat. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut eget eros nibh, quis luctus nibh. Nam a metus eu ligula eleifend gravida ut a dolor. Donec et diam metus, convallis dictum erat? Nullam et nisi ut dolor sollicitudin sodales et quis justo. Etiam dapibus purus et diam congue quis faucibus orci ultricies. Nullam dignissim, est in placerat gravida, turpis nibh tincidunt felis, ut suscipit mi mauris imperdiet urna.</p>');

-- ----------------------------
-- Table structure for `kanc__file`
-- ----------------------------
DROP TABLE IF EXISTS `kanc__file`;
CREATE TABLE `kanc__file` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(255) COLLATE utf8_polish_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_polish_ci NOT NULL,
  `path` varchar(255) COLLATE utf8_polish_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci;

-- ----------------------------
-- Records of kanc__file
-- ----------------------------
INSERT INTO `kanc__file` VALUES ('1', 'darmowy wzór nr 1', 'doc.pdf', 'media/upload/repository/1/4/');

-- ----------------------------
-- Table structure for `kanc__galleries`
-- ----------------------------
DROP TABLE IF EXISTS `kanc__galleries`;
CREATE TABLE `kanc__galleries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gallery_kind_id` int(11) NOT NULL,
  `element_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci;

-- ----------------------------
-- Records of kanc__galleries
-- ----------------------------
INSERT INTO `kanc__galleries` VALUES ('1', '1', '1');
INSERT INTO `kanc__galleries` VALUES ('2', '1', '2');
INSERT INTO `kanc__galleries` VALUES ('3', '1', '3');
INSERT INTO `kanc__galleries` VALUES ('4', '1', '4');

-- ----------------------------
-- Table structure for `kanc__gallery_image`
-- ----------------------------
DROP TABLE IF EXISTS `kanc__gallery_image`;
CREATE TABLE `kanc__gallery_image` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` int(11) NOT NULL,
  `gallery_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `file_id` (`image_id`,`gallery_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci;

-- ----------------------------
-- Records of kanc__gallery_image
-- ----------------------------

-- ----------------------------
-- Table structure for `kanc__image`
-- ----------------------------
DROP TABLE IF EXISTS `kanc__image`;
CREATE TABLE `kanc__image` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL DEFAULT '0',
  `label` varchar(255) COLLATE utf8_polish_ci NOT NULL,
  `label_en` varchar(255) COLLATE utf8_polish_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_polish_ci NOT NULL,
  `path` varchar(255) COLLATE utf8_polish_ci NOT NULL,
  `sort` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci;

-- ----------------------------
-- Records of kanc__image
-- ----------------------------

-- ----------------------------
-- Table structure for `kanc__language`
-- ----------------------------
DROP TABLE IF EXISTS `kanc__language`;
CREATE TABLE `kanc__language` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `short_name` varchar(255) NOT NULL,
  `icon` varchar(255) NOT NULL,
  `show` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kanc__language
-- ----------------------------
INSERT INTO `kanc__language` VALUES ('1', 'polski', 'PL', '', '1');
INSERT INTO `kanc__language` VALUES ('2', 'angielski', 'EN', '', '1');

-- ----------------------------
-- Table structure for `kanc__option`
-- ----------------------------
DROP TABLE IF EXISTS `kanc__option`;
CREATE TABLE `kanc__option` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_polish_ci DEFAULT NULL,
  `value` text COLLATE utf8_polish_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=54 DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci;

-- ----------------------------
-- Records of kanc__option
-- ----------------------------
INSERT INTO `kanc__option` VALUES ('1', 'contact_1_email', 'l.bucikiewicz@a-tech.pl');
INSERT INTO `kanc__option` VALUES ('2', 'contact_1_text', '<p><strong>Kancelaria Radców Prawnych K.Materna, A. Ossowska Spółka Partnerska. </strong><br /><br />ul. Staszica 10/3<br />60-527 Poznań<br />tel.: 00 48 61 847 54 16<br />fax: 00 48 61 847 54 16<br />mobile tel.: 0 501 744 910<br /><br />sekretariat e-mail: <a href=\"mailto:kancelaria@materna-ossowska.pl\">kancelaria@materna-ossowska.pl</a><br />radca prawny Katarzyna Materna e-mail:<a href=\"mailto:k.materna@materna-ossowska.pl\"> k.materna@materna-ossowska.pl</a>,<br />radca prawny Anna Ossowska e-mail: <a href=\"mailto:a.ossowska@materna-ossowska.pl\">a.ossowska@materna-ossowska.pl</a>,</p>\n<p><br />KRS 0000192976<br />REGON (statistical Id no.) 634553805<br />NIP 781 17 41 656</p>');
INSERT INTO `kanc__option` VALUES ('3', 'contact_1_text2', '<p><strong>Kancelaria Radców Prawnych K. Materna</strong></p>\n<p><strong>A. Ossowska Spółka Partnerska</strong></p>\n<p>ul. Stasica 10/3</p>\n<p>60-527 Poznań</p>\n<p> </p>\n<p>tel.: 00 48 61 847 54 16</p>\n<p>GSM 0 501 744 910</p>\n<p><a href=\"mailto:kancelaria@materna-ossowska.pl\">kancelaria@materna-ossowska.pl</a></p>\n<div id=\"_mcePaste\" class=\"mcePaste\" style=\"position: absolute; left: -10000px; top: 0px; width: 1px; height: 1px; overflow: hidden;\">Kancelaria Radców Prawnych K.Materna, A. Ossowska Spółka Partnerska. <br /><br />ul. Staszica 10/3<br />60-527 Poznań<br />tel.: 00 48 61 847 54 16<br />fax: 00 48 61 847 54 16<br />mobile tel.: 0 501 744 910<br /><br />sekretariat e-mail: kancelaria@materna-ossowska.pl<br />radca prawny Katarzyna Materna e-mail: k.materna@materna-ossowska.pl,<br />radca prawny Anna Ossowska e-mail: a.ossowska@materna-ossowska.pl,<br />KRS 0000192976<br />REGON (statistical Id no.) 634553805<br />NIP 781 17 41 656</div>');
INSERT INTO `kanc__option` VALUES ('4', 'main_1_body', '<p><span>Miło nam gościć Państwa na naszej  stronie. Ufamy, że zaprezentowane tu informacje będą wystarczające, by w  pełni ocenić profesjonalizm oraz nasze możliwości w zakresie szeroko  pojętego  kształtowania architektury krajobrazu. </span></p>\n<p><span>W razie pytań jesteśmy do Państwa dyspozycji.</span></p>\n<p><span>Zapraszamy do współpracy.</span></p>');
INSERT INTO `kanc__option` VALUES ('6', 'meta_1_title', 'Kancelaria');
INSERT INTO `kanc__option` VALUES ('7', 'meta_1_description', 'Opis strony');
INSERT INTO `kanc__option` VALUES ('8', 'meta_1_keywords', 'Słowa kluczowe');
INSERT INTO `kanc__option` VALUES ('9', 'contact_2_email', 'biuro@porosa.pl');
INSERT INTO `kanc__option` VALUES ('10', 'contact_2_text', '<p><strong>Kancelaria Radców Prawnych K. Materna</strong></p>\n<p><strong>A. Ossowska Spółka Partnerska</strong></p>\n<p>ul. Stasica 10/3</p>\n<p>60-527 Poznań</p>\n<p> </p>\n<p>tel.: 00 48 61 847 54 16</p>\n<p>GSM 0 501 744 910</p>\n<p><a href=\"mailto:kancelaria@materna-ossowska.pl\">kancelaria@materna-ossowska.pl</a></p>');
INSERT INTO `kanc__option` VALUES ('11', 'contact_2_text2', null);
INSERT INTO `kanc__option` VALUES ('15', 'main_2_body', '<p><strong>Welcome on our web site</strong><br /><br />We hope that you will find this site a useful source of information about anchitecture of landscape, our company and work. It includes informations about our offer, projects, how to contact us and many more. We hope that you will find it helpful and informative.</p>');
INSERT INTO `kanc__option` VALUES ('16', 'meta_2_title', 'Chancellery');
INSERT INTO `kanc__option` VALUES ('17', 'meta_2_description', 'Opis strony EN');
INSERT INTO `kanc__option` VALUES ('18', 'meta_2_keywords', 'słowa kluczowe EN');
INSERT INTO `kanc__option` VALUES ('44', 'message_contact_1_title', 'Kontakt ze strony materna-ossowska.pl');
INSERT INTO `kanc__option` VALUES ('45', 'message_contact_1_head', '<p>jakiś top, np: Dziękujemy za skorzystane z formularza, odezwiemy się wkrótce</p>');
INSERT INTO `kanc__option` VALUES ('46', 'message_contact_1_foot', '<p>dane kontaktowe:</p>\n<p><strong>Kancelaria Radców Prawnych K. Materna</strong></p>\n<p><strong>A. Ossowska Spółka Partnerska</strong></p>\n<p>ul. Stasica 10/3</p>\n<p>60-527 Poznań</p>\n<p> </p>\n<p>tel.: 00 48 61 847 54 16</p>\n<p>GSM 0 501 744 910</p>\n<p><a href=\"mailto:kancelaria@materna-ossowska.pl\">kancelaria@materna-ossowska.pl</a></p>');
INSERT INTO `kanc__option` VALUES ('47', 'message_contact_2_title', 'Kontakt ze strony porosa.pl : EN');
INSERT INTO `kanc__option` VALUES ('48', 'message_contact_2_head', '<p>top</p>');
INSERT INTO `kanc__option` VALUES ('49', 'message_contact_2_foot', '<p>foot</p>');
INSERT INTO `kanc__option` VALUES ('50', 'main_1_link1', 'http://prawoteka.pl/article_young/show/371,prawo_dla_dzieci');
INSERT INTO `kanc__option` VALUES ('51', 'main_1_link2', 'http://prawoteka.pl/article/show/49,skorzystasz_z_uslug_prawnika');
INSERT INTO `kanc__option` VALUES ('52', 'main_2_link1', null);
INSERT INTO `kanc__option` VALUES ('53', 'main_2_link2', null);

-- ----------------------------
-- Table structure for `kanc__repositories`
-- ----------------------------
DROP TABLE IF EXISTS `kanc__repositories`;
CREATE TABLE `kanc__repositories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `repository_kind_id` int(11) NOT NULL,
  `element_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci;

-- ----------------------------
-- Records of kanc__repositories
-- ----------------------------
INSERT INTO `kanc__repositories` VALUES ('4', '1', '10');
INSERT INTO `kanc__repositories` VALUES ('5', '1', '11');
INSERT INTO `kanc__repositories` VALUES ('6', '1', '12');
INSERT INTO `kanc__repositories` VALUES ('7', '1', '13');
INSERT INTO `kanc__repositories` VALUES ('8', '1', '14');
INSERT INTO `kanc__repositories` VALUES ('9', '1', '1');
INSERT INTO `kanc__repositories` VALUES ('10', '1', '2');
INSERT INTO `kanc__repositories` VALUES ('11', '1', '3');
INSERT INTO `kanc__repositories` VALUES ('12', '1', '4');

-- ----------------------------
-- Table structure for `kanc__repository_file`
-- ----------------------------
DROP TABLE IF EXISTS `kanc__repository_file`;
CREATE TABLE `kanc__repository_file` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_id` int(11) NOT NULL,
  `repository_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `file_id` (`file_id`,`repository_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci;

-- ----------------------------
-- Records of kanc__repository_file
-- ----------------------------
INSERT INTO `kanc__repository_file` VALUES ('7', '1', '12');
INSERT INTO `kanc__repository_file` VALUES ('3', '3', '2');
INSERT INTO `kanc__repository_file` VALUES ('5', '5', '4');
INSERT INTO `kanc__repository_file` VALUES ('6', '6', '4');

-- ----------------------------
-- Table structure for `kanc__sitemap`
-- ----------------------------
DROP TABLE IF EXISTS `kanc__sitemap`;
CREATE TABLE `kanc__sitemap` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content_id` int(11) DEFAULT NULL,
  `uri` varchar(256) NOT NULL,
  `date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `show` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uri` (`uri`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kanc__sitemap
-- ----------------------------
INSERT INTO `kanc__sitemap` VALUES ('1', null, '', '2012-02-23 12:44:58', '1');
INSERT INTO `kanc__sitemap` VALUES ('2', null, '1.kancelaria.html', '2012-02-23 12:45:04', '1');
INSERT INTO `kanc__sitemap` VALUES ('3', null, 'contact', '2012-02-23 12:50:28', '1');
INSERT INTO `kanc__sitemap` VALUES ('4', null, '2.cennik.html', '2012-02-23 13:23:28', '1');
INSERT INTO `kanc__sitemap` VALUES ('5', null, '3.kancelaria-dla-dzieci.html', '2012-02-23 13:41:23', '1');
INSERT INTO `kanc__sitemap` VALUES ('6', null, '4.darmowe-wzory.html', '2012-02-23 13:46:30', '1');

-- ----------------------------
-- Table structure for `kanc__translation`
-- ----------------------------
DROP TABLE IF EXISTS `kanc__translation`;
CREATE TABLE `kanc__translation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL,
  `label` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kanc__translation
-- ----------------------------
INSERT INTO `kanc__translation` VALUES ('1', '1', 'LABEL_main_site');
INSERT INTO `kanc__translation` VALUES ('2', '1', 'TEXT_MAIN_BOX1');
INSERT INTO `kanc__translation` VALUES ('3', '1', 'TEXT_MAIN_BOX2');
INSERT INTO `kanc__translation` VALUES ('4', '1', 'BUTTON_LABEL_DOWNLOAD');
INSERT INTO `kanc__translation` VALUES ('5', '1', 'BUTTON_LABEL_MORE');
INSERT INTO `kanc__translation` VALUES ('6', '1', 'TEXT_CONTACT');
INSERT INTO `kanc__translation` VALUES ('7', '1', 'LABEL_KONTAKT');
INSERT INTO `kanc__translation` VALUES ('8', '1', 'LABEL_NAME_SURENAME');
INSERT INTO `kanc__translation` VALUES ('9', '1', 'PHONE');
INSERT INTO `kanc__translation` VALUES ('10', '1', 'SECURITY_CODE');
INSERT INTO `kanc__translation` VALUES ('11', '1', 'COMPANY');
INSERT INTO `kanc__translation` VALUES ('12', '1', 'MAIL_TEXT');
INSERT INTO `kanc__translation` VALUES ('13', '1', 'LABEL_CONTACT_FORM');
INSERT INTO `kanc__translation` VALUES ('14', '1', 'HEAD_SITE_NAME');
INSERT INTO `kanc__translation` VALUES ('15', '1', 'LABEL_all_rights_reserved');
INSERT INTO `kanc__translation` VALUES ('16', '1', 'LABEL_created_by');
INSERT INTO `kanc__translation` VALUES ('17', '1', 'LABEL_files_to_download');
INSERT INTO `kanc__translation` VALUES ('18', '1', 'LABEL_gallery');

-- ----------------------------
-- Table structure for `kanc__translation_detail`
-- ----------------------------
DROP TABLE IF EXISTS `kanc__translation_detail`;
CREATE TABLE `kanc__translation_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `translation_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `translation_id` (`translation_id`),
  KEY `language_id` (`language_id`)
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kanc__translation_detail
-- ----------------------------
INSERT INTO `kanc__translation_detail` VALUES ('1', '1', '1', 'Strona główna');
INSERT INTO `kanc__translation_detail` VALUES ('2', '1', '2', 'Main Site');
INSERT INTO `kanc__translation_detail` VALUES ('3', '2', '1', 'Lekcje prawa dla dzieci i młodzieży');
INSERT INTO `kanc__translation_detail` VALUES ('4', '2', '2', 'Law lessons for children and youth');
INSERT INTO `kanc__translation_detail` VALUES ('5', '3', '1', 'Co musisz wiedzieć zanim...');
INSERT INTO `kanc__translation_detail` VALUES ('6', '3', '2', 'What You must know before...');
INSERT INTO `kanc__translation_detail` VALUES ('7', '4', '1', 'POBIERZ');
INSERT INTO `kanc__translation_detail` VALUES ('8', '4', '2', 'DOWNLOAD');
INSERT INTO `kanc__translation_detail` VALUES ('9', '5', '1', 'WIĘCEJ');
INSERT INTO `kanc__translation_detail` VALUES ('10', '5', '2', 'MORE');
INSERT INTO `kanc__translation_detail` VALUES ('11', '6', '1', 'Kontakt');
INSERT INTO `kanc__translation_detail` VALUES ('12', '6', '2', 'Contact');
INSERT INTO `kanc__translation_detail` VALUES ('13', '7', '1', 'Kontakt');
INSERT INTO `kanc__translation_detail` VALUES ('14', '7', '2', 'Contact');
INSERT INTO `kanc__translation_detail` VALUES ('15', '8', '1', 'Imię, Nazwisko');
INSERT INTO `kanc__translation_detail` VALUES ('16', '8', '2', 'Name, Surename');
INSERT INTO `kanc__translation_detail` VALUES ('17', '9', '1', 'Telefon');
INSERT INTO `kanc__translation_detail` VALUES ('18', '9', '2', 'Phone');
INSERT INTO `kanc__translation_detail` VALUES ('19', '10', '1', 'Kod zabezpieczający');
INSERT INTO `kanc__translation_detail` VALUES ('20', '10', '2', 'Security Code');
INSERT INTO `kanc__translation_detail` VALUES ('21', '11', '1', 'Firma');
INSERT INTO `kanc__translation_detail` VALUES ('22', '11', '2', 'Company');
INSERT INTO `kanc__translation_detail` VALUES ('23', '12', '1', 'Treśc wiadomości');
INSERT INTO `kanc__translation_detail` VALUES ('24', '12', '2', 'Mail Text');
INSERT INTO `kanc__translation_detail` VALUES ('25', '13', '1', 'Formularz kontaktowy');
INSERT INTO `kanc__translation_detail` VALUES ('26', '13', '2', 'Contact Form');
INSERT INTO `kanc__translation_detail` VALUES ('27', '14', '1', 'RADCY PRAWNI SPÓŁKA PARTNERSKA');
INSERT INTO `kanc__translation_detail` VALUES ('28', '14', '2', 'LEGAL ADVISERS LIMITED LIABILITY PARTNERSHIP');
INSERT INTO `kanc__translation_detail` VALUES ('29', '15', '1', 'Wszystkie prawa zastrzeżone.');
INSERT INTO `kanc__translation_detail` VALUES ('30', '15', '2', 'All rights reserved.');
INSERT INTO `kanc__translation_detail` VALUES ('31', '16', '1', 'Projekt i wykonanie');
INSERT INTO `kanc__translation_detail` VALUES ('32', '16', '2', 'Site created by');
INSERT INTO `kanc__translation_detail` VALUES ('33', '17', '1', 'Pliki do pobrania');
INSERT INTO `kanc__translation_detail` VALUES ('34', '17', '2', 'Files to download');
INSERT INTO `kanc__translation_detail` VALUES ('35', '18', '1', 'Galeria');
INSERT INTO `kanc__translation_detail` VALUES ('36', '18', '2', 'Gallery');
