<?php

defined('SYSPATH') or die('No direct script access.');

class Widget_View {

    protected $default_view = NULL;
    protected $view = NULL;
    protected $show = TRUE;

    public function render() {
	if (!$this->show)
	    return '';
	$this->set_view($this->view);
	$this->prepare_view();
	return $this->view;
    }

    public function get_show() {
	return $this->show;
    }

    public function set_show($show = TRUE) {
	$this->show = $show;
    }

    public function show() {
	return $this->set_show();
    }

    public function hide() {
	return $this->set_show(FALSE);
    }

    public function __toString() {
	try {
	    return (string) $this->render();
	} catch (Exception $e) {
	    return 'Wystąpił wyjątek:' . $e->getMessage();
	}
    }

    /**
     * sets view to be used for form rendering
     * @param mixed $view View to be used (string or an instance of Kohana_View)
     */
    public function set_view($view = NULL) {
	if ($view === NULL) {
	    $view = $this->get_default_view();
	} elseif ($view === $this->view) {
	    return;
	}

	if ($view instanceof Kohana_View) {
	    $this->view = $view;
	} elseif (is_string($view)) {
	    $this->view = View::factory($view);
	} elseif (is_null($view)) {
	    throw new Exception('View not set and default is undefined.');
	} else {
	    throw new Exception('Unsupported type of view.');
	}
    }

    public function get_default_view() {
	return $this->default_view;
    }

    protected function prepare_view() {

    }

}

?>
