<?php

defined('SYSPATH') or die('No direct script access.');

class Widget_Renderer_Factory {
    const DEFAULT_PREFIX = 'Widget_Renderer_';
    const COMMON_PREFIX = 'Common_';
    const DEFAULT_RENDERER = 'Text';
    private static $cache_renderer = array();
    private $group;

    public function __construct($group = '') {
	$this->set_group($group);
    }

    public function set_group($group) {
	$this->group = ucfirst((string) $group);
    }

    public function get_renderer($renderer_name) {
	if (!isset(self::$cache_renderer[$renderer_name])) {
	    $class_name = $this->get_renderer_class_name($renderer_name);
	    self::$cache_renderer[$renderer_name] = new $class_name;
	}

	return self::$cache_renderer[$renderer_name];
    }

    private function get_renderer_class_name($name) {
	$class_name = $this->try_load_class_name($name);
	if ($class_name) {
	    return $class_name;
	}
	$name = explode('_', $name);
	if (isset($name[1])) {
	    $class_name = $this->try_load_class_name(self::COMMON_PREFIX . $name[1]);
	    if ($class_name) {
		return $class_name;
	    }
	}
	return self::DEFAULT_PREFIX . self::DEFAULT_RENDERER;
    }

    private function try_load_class_name($name) {
	$class_name = self::DEFAULT_PREFIX . $this->group. '_' . $name;
	if (class_exists($class_name)) {
	    return $class_name;
	}
	$class_name = self::DEFAULT_PREFIX . $name;
	if (class_exists($class_name)) {
	    return $class_name;
	}
	return false;
    }

}

?>
