<?php

defined('SYSPATH') or die('No direct script access.');

class Widget_Renderer_Anchor extends Widget_Renderer {

    protected $attributes;
    protected $label;
    protected $anchor;
    protected $query_string;

    protected function set_value($value) {
        $this->attributes = $value['attributes'];
        $this->label = $value['label'];
        $this->anchor = $value['anchor'];
    }
    
    protected function set_query_string($value) {
        $query_string = (isset($value['query_string']) ? $value['query_string'] : array());
        $this->query_string = array();
        if (count($query_string)) {
            foreach($query_string as $param=>$val) {
                $this->query_string[] = $param.'='.$val;
            }
        }
    }

    protected function generate_html() {
        return HTML::anchor($this->anchor . (count($this->query_string)>0 ? '?'.implode('&',$this->query_string) : ''), $this->label, $this->attributes);
    }

}

?>
