<?php

defined('SYSPATH') or die('No direct script access.');

class Widget_Message {
    const STATUS_EMPTY = 0;
    const STATUS_SUCCESS = 1;
    const STATUS_ERROR = 2;

    static protected $default_view = 'message';
    protected $status = self::STATUS_EMPTY;
    protected $text = '';
    protected $view = NULL;
    protected $view_class = array(
        'div' => array(
            self::STATUS_EMPTY => '',
            self::STATUS_SUCCESS => 'ui-state-highlight ui-corner-all',
            self::STATUS_ERROR => 'ui-state-error ui-corner-all',
        ),
        'span' => array(
            self::STATUS_EMPTY => '',
            self::STATUS_SUCCESS => 'ui-icon ui-icon-info',
            self::STATUS_ERROR => 'ui-icon ui-icon-alert',
        ),
    );
    static protected $default_text = array(
        self::STATUS_EMPTY => '',
        self::STATUS_SUCCESS => 'Operacja została wykonana pomyślnie.',
        self::STATUS_ERROR => 'Operacja nie powiodła się.',
    );

    public function __construct($status = self::STATUS_EMPTY, $message = '') {
        $this->text = $message;
        $this->status = $status === NULL ? self::STATUS_EMPTY : $status;
    }

    public function set_status($status) {
        $this->status = $status;
    }

    public function set_text($text) {
        $this->text = $text;
    }

    public function __toString() {
        return (string) $this->render();
    }

    public function get_text() {
        if (!empty($this->text)){
            if(is_array($this->text)) {
                return '<b>'.Kohana_Session::instance()->get('translate')->LABEL_wystapily_bledy.':</b>' . '<ul><li>' . implode('</li><li>', $this->text) . '</li></ul>';
            }
            return $this->text;
        }
        return self::$default_text[$this->status];
    }

    protected function get_view_class($element) {
        return $this->view_class[$element][$this->status];
    }

    protected function get_view($view = NULL) {
        if (!empty($view))
            return $view;
        if (!empty($this->view))
            return $this->view;
        return self::$default_view;
    }

    public function render($view = NULL) {
        if ($this->status == self::STATUS_EMPTY)
            return '';
        $view = $this->get_view($view);
        $view = View::factory($view);
        $view->div_class = $this->get_view_class('div');
        $view->span_class = $this->get_view_class('span');
        $view->message = $this->get_text();
        return $view;
    }

}

?>
