<?php

defined('SYSPATH') or die('No direct script access.');

class Widget_Menu_Entry extends Widget_View {

    protected $default_views = array('menu' => 'common/menu', 'entry' => 'common/menu/entry');
    protected $action;
    protected $action_prefix;
    protected $name;
    protected $path = '';
    protected $label = '';
    protected $parent = NULL;
    protected $children = array();
    protected $empty_for_view = NULL;

    public function __construct($name, Widget_Menu_Entry $parent = NULL, $label = '', $action = '', $action_prefix = '') {
        $parent_path = '';
        $parent_action_prefix = '';
        if ($parent !== NULL) {
            if (!empty($parent->path)) {
                $parent_path = $parent->path . '/';
            }
            $parent_action_prefix = $parent->get_action_prefix();
        }
        $this->path = $parent_path . $name;
        $this->name = $name;

        $this->label = $label;
        $this->action = $action;
        $this->action_prefix = $action_prefix;

        if (empty($this->action_prefix)) {
            $this->action_prefix = $parent_action_prefix;
        }

        if (empty($this->action)) {
            $this->action = $this->action_prefix . '/' . $name;
        }

        if (empty($this->label)) {
            $this->label = $this->name;
        }
//        echo '-----';
//        var_dump($this->name, $this->label, $this->path, $this->action);
//        echo '-----';
    }

    public function is_empty() {
        return!($this->show OR $this->has_children());
    }

    public function is_empty_for_view() {
        if ($this->empty_for_view !== NULL)
            return $this->empty_for_view;

        $result = TRUE;
        if (!$this->is_empty()) {
            foreach ($this->children as $child) {
                if (!$child->is_empty_for_view()) {
                    $result = FALSE;
                    break;
                }
            }
            $result = !$this->show;
        }
        $this->empty_for_view = $result;
        return $this->empty_for_view;
    }

    public function get_action_prefix() {
        return $this->action_prefix;
    }

    public function get_label() {
        return $this->label;
    }

    public function set_label($label) {
        $this->label = $label;
    }

    public function get_action() {
        return $this->action;
    }

    public function get_name() {
        return $this->name;
    }

    public function get_path() {
        return $this->path;
    }

    public function get_parent() {
        return $this->parent;
    }

    public function get_children() {
        return $this->children;
    }

    public function is_menu() {
        return $this->has_children();
    }

    public function has_children() {
        return!empty($this->children);
    }

    public function add_child($node, $name = NULL) {
        if (empty($name)) {
            $this->children[] = $node;
        } else {
            $this->children[$name] = $node;
        }
    }

    public function get_default_view() {
        if ($this->is_menu())
            return $this->default_views['menu'];
        else
            return $this->default_views['entry'];
    }

    public function get_children_for_view() {
        $sub_menu = array();
        foreach ($this->children as $child) {
            if (!$child->is_empty_for_view()) {
                $sub_menu[] = $child;
            }
        }
        return $sub_menu;
    }

    protected function prepare_view() {
        $this->view->action = $this->get_action();
        $this->view->label = $this->get_label();
        $this->view->menu = $this->get_children_for_view();
    }

}

?>
