<?php

defined('SYSPATH') or die('No direct script access.');

/**
 * Description of access
 * @TODO this module works by setting an empty view to the fields where there is
 * no view access. The menu tree is created though. There is a reason for this.
 * If a parent node had view/access forbidden (for default) its submenu would not be created.
 * Then if the submenu have had its own access set to allow, it would
 * be not shown (nor exist) anyway.
 * Proposed solution is to implement access and view regardless of each other.
 * No view right would set an empty view. No access would not create the whole node.
 * @author luk32
 */
class Widget_Menu_Access extends Widget_Menu {

    protected $user;
    protected $access_id;

    public function __construct($config, $view = NULL, $access_id = 'menu', $user = NULL) {
        $this->user = $user;
        if ($this->user === NULL) {
            $this->user = simpleauth::instance()->get_user();
        }
        $this->access_id = $access_id;

        $auth = authorize::instance();
        if (!$auth->has_right($this->user, $this->get_aid())) {
            $this->set_view('common/empty');
            return;
        }
        parent::__construct($config, $view);
    }

    protected function load_treenode_from_modelnode($model_node, $name, Widget_Menu_Entry $parent = NULL) {
        /**
         * @var string $element_aid menu node access identfier
         */
        $auth = authorize::instance();
        $element_aid = $this->get_aid('view', $name, $parent);
        //var_dump($element_aid, $auth->has_right($this->user, $element_aid));
        $node = parent::load_treenode_from_modelnode($model_node, $name, $parent);
        if (!(bool) $auth->has_right($this->user, $element_aid)) {
            $node->hide();
        }
        return $node;
    }

    protected function get_aid($action = 'access', $name = '', $parent = NULL) {
        $parent_path = empty($parent) ? '' : ($parent->get_path());
        if (!empty($parent_path)) {
            $parent_path .= '.';
        }
        if (!empty($name)) {
            $name .= '.';
        }

        //translate menu path into access path
        $path = strtr($parent_path, '/', '.');
        $element_aid = $this->access_id . '.' . $path . $name . $action;
        return $element_aid;
    }

}

?>
