<?php

defined('SYSPATH') or die('No direct script access.');

class Widget_Menu extends Widget_View {

    protected $default_view = 'common/menu';
    protected $menu_tree = array();
    protected $menu_tree_loaded = FALSE;
    protected $menu_model = NULL;
    protected $config = NULL;

    public function __construct($config, $view = NULL) {
        $this->assign_config($config);
        $this->set_view($view);
    }

    protected function get_menu_tree() {
        $this->load_menu_tree();
        return $this->menu_tree;
    }

    protected function assign_config($config) {
        if ($config instanceof Kohana_Config_File) {
            $this->config = $config;
        } elseif (is_string($config)) {
            $this->assign_config_from_file($config);
        }
        if (!array_key_exists('sections', $this->config))
            throw new Exception('The specified config does not contain \'sections\' key!!');
        $this->menu_model = $this->config;
    }

    protected function assign_config_from_file($filename) {
        $this->file = $filename;
        $this->config = Kohana::config($filename);
    }

    protected function load_menu_tree() {
        if ($this->menu_tree_loaded)
            return;

        $queue = array();
        $this->menu_tree = $this->load_treenode_from_modelnode($this->menu_model, '');
        array_push($queue, array($this->menu_tree, $this->menu_model));

        while (count($queue) > 0) {
            list($tree_node, $model_node) = array_pop($queue);
            $this->load_menu_process_node($queue, $tree_node, $model_node);
        }

        $this->menu_tree_loaded = 1;
    }

    protected function load_menu_process_node(&$queue, &$tree_node, &$model_node) {
        foreach ($model_node['sections'] as $name => $model_child_node) {
            $tree_child_node = $this->load_treenode_from_modelnode($model_child_node, $name, $tree_node);
            if (is_array($model_child_node) AND array_key_exists('sections', $model_child_node)) {
                array_push($queue, array($tree_child_node, $model_child_node));
            }
        }
    }

    protected function load_treenode_from_modelnode($model_node, $name, Widget_Menu_Entry $parent = NULL) {
        if (!( is_array($model_node) OR $model_node instanceof ArrayAccess )) {
            $new_tree_node = new Widget_Menu_Entry($name, $parent, $model_node);
        } else {
            $action = array_key_exists('action', $model_node) ? $model_node['action'] : NULL;
            $action_prefix = array_key_exists('action_prefix', $model_node) ? $model_node['action_prefix'] : NULL;
            $label = array_key_exists('label', $model_node) ? $model_node['label'] : NULL;
            $new_tree_node = new Widget_Menu_Entry($name, $parent, $label, $action, $action_prefix);
        }
        if ($parent !== NULL) {
            $parent->add_child($new_tree_node, $name);
        }
        return $new_tree_node;
    }
    protected function prepare_view() {
        $this->view->label = '';
        $this->view->menu = $this->get_menu_tree()->get_children_for_view();
    }
}

?>
