<?php

defined('SYSPATH') or die('No direct script access.');

class Widget_List_Factory {
    const LIST_DEFAULT = 'Widget_List';
    const LIST_CRITERIA = 'Widget_List_Criteria';

    public static function get_list_widget($view, $columns, $values, $renderer_group = '', $renderers) {
        $widget_name = self::select_list_widget_class($renderers);
        $widget_list = call_user_func(array($widget_name, 'factory'), $view, $columns, $values, $renderer_group);
        $widget_list = self::apply_list_widget_renderers($widget_list, $renderers);
        return $widget_list;
    }

    private static function select_list_widget_class($renderers) {
        foreach ($renderers as $renderer) {
            if (is_array($renderer['row'])) {
                return self::LIST_CRITERIA;
                break;
            }
        }
        return self::LIST_DEFAULT;
    }

    private static function apply_list_widget_renderers($widget_list, $renderers) {
        foreach ($renderers as $renderer) {
            $widget_list->set_renderer($renderer['renderer'], $renderer['column'], $renderer['row']);
        }
        return $widget_list;
    }

}

?>
