<?php

defined('SYSPATH') or die('No direct script access.');

class Widget_List_Criteria extends Widget_List {

    protected $renderers_by_criteria = array();

    public static function factory($view, $columns, $values, $renderer_group = '', $widget_class = __CLASS__) {
        return parent::factory($view, $columns, $values, $renderer_group, $widget_class);
    }

    private function set_renderer_to_column_by_criteria($renderer, $column, $criteria) {
        $this->renderers_by_criteria[] = array('renderer' => $renderer,
            'column' => $column,
            'criteria' => $criteria);
    }

    public function set_renderer($renderer, $column = '*', $row_or_criteria = '*') {
        if (is_string($row_or_criteria)) {
            parent::set_renderer($renderer, $column, $row_or_criteria);
        } elseif (is_array($row_or_criteria)) {
            $this->set_renderer_to_column_by_criteria($renderer, $column, $row_or_criteria);
        } else {
            throw new Exception('Nieprawidłowy typ kryterium');
        }
    }

    protected function get_values_with_applied_renderers() {
        $values = parent::get_values_with_applied_renderers();
        foreach ($values as &$value) {
            foreach ($this->renderers_by_criteria as $renderer) {
                $value = $this->apply_renderer_with_criteria($value, $renderer);
            }
        }
        return $values;
    }

    private function apply_renderer_with_criteria($row, $renderer) {

        $criteria = $renderer['criteria'];
        $renderer_name = $renderer['renderer'];
        $column = $renderer['column'];
        foreach ($criteria as $key => $value) {

            if ($key == 'condition') {
                if (array_search($row['id'], $value) === FALSE) {
                    $renderer = $this->renderer_factory->get_renderer($renderer_name);
                    $row[$column] = $renderer->render($value);
                }
            } elseif ($value != 'aktualny' and $column == 'invoice') {
                if ($row['status'] != $value) {
                    $renderer = $this->renderer_factory->get_renderer($renderer_name);
                    $row[$column] = $renderer->render($value);
                }
            } elseif ($key == 'role') {
                foreach ($value as $allowed) {
                    foreach (simpleauth::factory()->get_user_roles() as $value) {
                        if ($value != $allowed) {
                            $renderer = $this->renderer_factory->get_renderer($renderer_name);
                            $row[$column] = $renderer->render($value);
                        }
                    }
                }
            } else {
                if (is_array($value)) {
                    foreach ($value as $one) {
                        if (in_array($one, $row)) {
                            $renderer = $this->renderer_factory->get_renderer($renderer_name);
                            $row[$column] = $renderer->render($value);
                        }
                    }
                } else {
                    if ($row[$key] == $value) {
                        $renderer = $this->renderer_factory->get_renderer($renderer_name);
                        $row[$column] = $renderer->render($value);
                    }
                }
            }
        }
        return $row;
    }

}

?>
