<?php

defined('SYSPATH') or die('No direct access allowed.');

class Widget_List {
    const ALL = '*';
    protected $view;
    protected $renderer_factory;
    protected $values;
    protected $columns;
    protected $renderers_descriptions = array();

    protected function __construct($view, $columns, $values, $renderer_factory = '') {
	$this->set_values($values);
	$this->set_columns($columns);
	$this->set_view($view);
	$this->set_renderer_factory($renderer_factory);
    }

    private function __clone() {
	
    }

    public static function factory($view, $columns, $values, $renderer_group = '', $widget_class = __CLASS__) {
	$renderer_factory = new Widget_Renderer_Factory($renderer_group);
	$widget = new $widget_class(View::factory($view), $columns, $values, $renderer_factory);
	return Widget_Decorator::decorate_widget_for_view($widget, $view);
    }

    protected function set_values($values) {
	$this->values = $values;
    }

    protected function count_rows() {
	return count($this->values);
    }

    protected function count_columns() {
	return (count($this->columns));
    }

    protected function set_columns($columns) {
	$this->columns = $columns;
    }

    protected function set_view($view) {
	$this->view = $view;
    }

    public function __toString() {
	return $this->render();
    }

    public function set_renderer_factory($renderer_factory) {
	$this->renderer_factory = $renderer_factory;
    }

    public function set_renderer($renderer, $column = '*', $row='*') {
	$column = (string) $column;
	$row = (string) $row;
	if (empty($this->values)) {
	    
	} elseif ($column == self::ALL && $row == self::ALL) {
	    $this->fill_renderers_descriptions_table($renderer);
	} elseif ($column == self::ALL) {
	    $this->fill_renderers_descriptions_row($row, $renderer);
	} elseif ($row == self::ALL) {
	    $this->fill_renderers_descriptions_column($column, $renderer);
	} else {
	    $this->renderers_descriptions[$row][$column] = $renderer;
	}
    }

    protected function fill_renderers_descriptions_table($value) {
	$renderers_row = $this->get_renderers_row($value);
	$rows_number = count($this->values);
	$row_keys = array_keys($this->values);
	foreach ($row_keys as $key) {
	    $this->renderers_descriptions[$key] = $renderers_row;
	}
    }

    protected function get_renderers_row($decorator) {
	$keys = array_keys(reset($this->values));
	$renderers_row = array_fill(0, count($keys), $decorator);
	return array_combine($keys, $renderers_row);
    }

    protected function fill_renderers_descriptions_row($row, $value) {
	$this->renderers_descriptions[$row] = $this->get_renderers_row($value);
    }

    protected function fill_renderers_descriptions_column($column, $value) {
	$row_keys = array_keys($this->values);
	foreach ($row_keys as $key) {
	    $this->renderers_descriptions[$key][$column] = $value;
	}
    }

    public function set_paginator($paginator) {
	$this->paginator = $paginator;
    }

    public function render() {
	$view = $this->view;
	$view->columns = $this->columns;
	$view->data = $this->get_values_with_applied_renderers();
	return $this->view;
    }

    protected function get_values_with_applied_renderers() {
	$values = $this->values;
	foreach ($this->renderers_descriptions as $row_key => $rows) {
	    foreach ($rows as $column_key => $renderer_name) {
		$renederer = $this->renderer_factory->get_renderer($renderer_name);
		try {
		    $values[$row_key][$column_key] = $renederer->render($values[$row_key][$column_key]);
		} catch (Exception $e) {

		}
	    }
	}
	return $values;
    }

}

?>
