<?php

defined('SYSPATH') or die('No direct script access.');

class Widget_Form_Field_Radio extends Widget_Form_Field {

    protected $checked;

    public function __construct($name, $value, $label = '', $checked = FALSE, array $attributes = array()) {
        parent::__construct($name, $value, $label, $attributes);
        $this->checked = $checked;
    }

    protected function prepare_attributes($attributes = array()) {
        $this->attributes['id'] = self::ID_PREFIX . $this->name . '_' . $this->value;
        $this->add_attributes($attributes);
    }

    public function set_checked($checked = TRUE) {
        $this->checked = $checked;
    }

    public function render() {
        return Form::radio($this->name, $this->value, $this->checked, $this->attributes);
    }

}

?>
