<?php

defined('SYSPATH') or die('No direct script access.');

abstract class Widget_Form_Field_Question_Extended extends Widget_Form_Field_Question {
    const DEFAULT_VIEW = 'poll/question_extended';

    protected $types;
    protected $radio_fields = array();

    public function __get($name) {
        $fields = $this->get_fields();
        if (isset($fields[$name]))
            return $fields[$name];
        return parent::__get($name);
    }

    public function get_fields($types = NULL, $exclude = FALSE) {
        if (empty($types)) {
            $types = array_keys($this->fields);
        } elseif (is_string($types)) {
            $types = array($types);
        }
        $return = array();

        if ($exclude) {
            $types = array_diff(array_keys($this->fields), $types);
        }
        foreach ($types as $type) {
            if (array_key_exists($type, $this->fields)) {
                $return += $this->fields[$type];
            }
        }
        return $return;
    }

    protected function set_checked_field_from_values($values) {
        $checked = @$values[$this->name];
        $fields = $this->get_fields(array('radio', 'checkbox'));
        if (!is_null($checked)) {
            $fields[$checked]->set_checked();
        }
    }

    public function render() {
        if ($this->view === NULL) {
            $this->set_view(self::DEFAULT_VIEW);
        }

        $error = $this->get_error();
        $suberrors = array();
        $errors_array = array();

        if (!empty($error))
            $errors_array[] = $error;

        $this->view->error = (empty($error) ? NULL : new Widget_Message(Widget_Message::STATUS_ERROR, $error));
        $this->view->fields = $this->get_fields('radio', TRUE);
        foreach ($this->view->fields as $field) {
            $suberror = $field->get_error();
            if (!empty($suberror))
                $errors_array[] = $suberror;
            $suberrors[$field->name] = (empty($suberror) ? NULL : new Widget_Message(Widget_Message::STATUS_ERROR, $suberror));
        }
        $this->view->suberrors = $suberrors;
        $this->view->field_errors = (empty($errors_array) ? NULL : new Widget_Message(Widget_Message::STATUS_ERROR, $errors_array));
        $this->view->radio_fields = $this->get_fields('radio');
        $this->view->field = $this;
        return $this->view;
    }

    public function get_rules() {
        $rules = parent::get_rules();
        foreach ($this->get_fields() as $subfield) {
            $rules += $subfield->get_rules();
        }
        return $rules;
    }

    public function get_labels() {
        $labels = parent::get_labels();
        foreach ($this->get_fields() as $subfield) {
            $labels += $subfield->get_labels();
        }
        return $labels;
    }

    public function set_errors($errors) {
        if (array_key_exists($this->name, $errors)) {
            $this->set_error($errors[$this->name]);
            unset($errors[$this->name]);
        }
        foreach ($this->get_fields() as $fieldname => $field) {
            $matches = array();
            $subfields_errors = array();
            foreach ($errors as $err_fieldname => $error) {
                if (preg_match('/' . $this->name . '_' . $fieldname . '.*/', $err_fieldname)) {
                    $subfields_errors[$err_fieldname] = $error;
                    unset($errors[$err_fieldname]);
                }
            }
            $this->$fieldname->set_errors($subfields_errors);
        }
    }

}

?>
