<?php

defined('SYSPATH') or die('No direct script access.');

abstract class Widget_Form_Field_Question extends Widget_Form_Field {
    const DEFAULT_VIEW = 'poll/question';

    protected $fields = array();
    protected $view = NULL;
    protected $radio_fields = array();

    public function __construct($name, $values, $label = NULL, $attributes = array(), $rules = array()) {
        parent::__construct($name, NULL, $label, $attributes, $rules);
        $this->prepare_fields($values);
        $this->set_checked_field_from_values($values);
    }

    protected function set_checked_field_from_values($values) {
        $checked = @$values[$this->name];
        if (!is_null($checked)) {
            $this->fields[$checked]->set_checked();
        }
    }

    abstract protected function prepare_fields($values);

    public function get_fields() {
        return $this->fields;
    }

    public function set_view($view) {
        if ($view instanceof Kohana_View) {
            $this->view = $view;
        } elseif (is_string($view)) {
            $this->view = View::factory($view);
        } else {
            throw new Exception('Unsupported type of $view given.');
        }
    }

    public function render() {
        if ($this->view === NULL) {
            $this->set_view(self::DEFAULT_VIEW);
        }
        $error = $this->get_error();

        $this->view->error = (empty($error) ? NULL : new Widget_Message(Widget_Message::STATUS_ERROR, $this->get_error()));
        $this->view->fields = $this->fields;
        $this->view->field = $this;
        return $this->view;
    }

}

?>
