<?php

defined('SYSPATH') or die('No direct script access.');

abstract class Widget_Form_Field extends Helper_Entity {
    const ID_PREFIX = 'form_';
    const LABEL_CLASS = 'form_label';
    protected $name;
    protected $value = '';
    protected $attributes = array();
    protected $rules = array();
    protected $filters = array();
    protected $callbacks = array();
    protected $label = '';
    protected $error = '';

    /**
     *
     * @param string $name name of the field
     * @param mixed $value value to be placed in the field
     * @param string $label textual label of the field
     * @param array $attributes attributes of the entry
     * @param array $rules rules for the value validation
     */
    public function __construct($name, $value = NULL, $label = NULL, $attributes = array(), $rules = array()) {
        $this->value = $value;
        $this->name = $name;
        $this->prepare_attributes($attributes);
        $this->add_rules($rules);
        $this->assign_label($label);
    }

    public function __toString() {
        return $this->render();
    }

    public function get_error() {
        return $this->error;
    }

    public function set_errors($errors) {
        if (array_key_exists($this->name, $errors)) {
            $this->set_error($errors[$this->name]);
        }
    }

    public function set_error($error) {
        $this->error = $error;
    }

    public function get_label() {
        return $this->label;
    }

    public function get_labels() {
        return array($this->name => $this->label);
    }

    public function get_rules() {
        return array($this->name => $this->rules);
    }

    public function get_filters() {
        return $this->filters;
    }

    public function get_callbacks() {
        return $this->callbacks;
    }

    abstract protected function render();

    protected function prepare_attributes($attributes = array()) {
        $this->attributes['id'] = self::ID_PREFIX . $this->name;
        $this->add_attributes($attributes);
    }

    protected function add_attributes($attributes) {
        $this->attributes += $attributes;
    }

    protected function assign_label($label) {
        if ($label !== NULL) {
            $this->label = new Widget_Form_Label(
                            $this->attributes['id'],
                            $label,
                            array('class' => self::LABEL_CLASS)
            );
        }
    }

    public function add_rules(array $rules = array()) {
        foreach ($rules as $name => $params) {
            if (!is_string($name)) {
                $name = $params;
                $params = null;
            }
            $this->rules[$name] = $params;
        }
    }

    /**
     * TODO: refactor along with add_rules
     * @param array $filters array of filters to be applied a filter can be either
     * a string $filter_name or a pair string $filter_name => array $params
     */
    public function add_filters(array $filters = array()) {
        foreach ($filters as $name => $params) {
            if (!is_string($name)) {
                $name = $params;
                $params = null;
            }
            $this->filters[$name] = $params;
        }
    }

    /**
     * TODO: completely untested
     * @param <type> $validate_callback_method 
     */
    public function add_callback($validate_callback_method) {
        $this->callbacks[] = $validate_callback_method;
    }

}

?>
