<?php

defined('SYSPATH') or die('No direct script access.');

class Widget_Decorator_Breadcrumb extends Widget_Decorator {

    private $parents = array();

    public function set_breadcrumb($parents) {
        $this->parents = $parents;
    }

    public function render() {
        $breadcrumb = array();
        $view = $this->widget->render();
        if (count($this->parents)) {
            foreach ($this->parents as $parent) {
                $breadcrumb[] = html::anchor($parent['anchor'], $parent['name'], array('class' => 'breadcrumb'));
            }
        }
        $view->breadcrumb = implode('&nbsp;&nbsp;&raquo;&nbsp;&nbsp;', $breadcrumb);
        return $view;
    }

}

?>
