<?php

defined('SYSPATH') or die('No direct access allowed.');

abstract class Widget_Decorator {

    protected $widget = '';

    public function __construct($widget) {
	$this->widget = $widget;
    }

    public function __call($name, $arguments) {
	return call_user_func_array(array($this->widget, $name), $arguments);
    }

    public function  __toString() {
        $this->render();
    }
    
    abstract function render();

    public static function decorate_widget_for_view($widget, $view) {
	switch ($view) {
	    case View::V_LIST:
		$widget = new Widget_Decorator_Title($widget);
		$widget = new Widget_Decorator_Anchor($widget);
		$widget = new Widget_Decorator_Pagination($widget);
                $widget = new Widget_Decorator_Breadcrumb($widget);
		break;
	}
	return $widget;
    }

}

?>
