<?php

defined('SYSPATH') or die('No direct script access.');

/**
 * Rozszerzenie Kohanowej utf8
 *
 * @author Andrzej Skupień
 * @version 1.0
 */
class UTF8 extends Kohana_UTF8 {
    /**
     * Funkcja przemienia dowolny łańcuch na łancuch przeznaczony do przyjaznych
     * linków
     * @param string $str łańcuch do przekształcenia
     * @return string przekształcony łańcuch
     */
    public static function user_friendly($str) {
	$str = UTF8::strtolower(preg_replace('/\s+/', '-', UTF8::transliterate_to_ascii($str)));
        $str = preg_replace('/[^a-zA-Z0-9\-\_]/', '', UTF8::transliterate_to_ascii($str));
        $str = str_replace(array('.',',','"','\'', '+'),'',$str);
        return $str;
    }

    public static function generate_random_string($length = 10) {
        $chars = "abcdefghijkmnpqrstuvwxyz23456789";
        srand((double) microtime() * 1000000);
        $i = 0;
        $random_string = '';
        while ($i < $length) {
            $num = rand() % strlen($chars);
            $tmp = substr($chars, $num, 1);
            $random_string = $random_string . $tmp;
            $i++;
        }
        return $random_string;
    }

}

?>
