<?php

defined('SYSPATH') or die('No direct access allowed.');

class Upload extends Kohana_Upload {

    public static function save(array $file, $filename = NULL, $directory = NULL, $chmod = 0644) {
        $name_expl = explode('.', $filename);
        $type = end($name_expl);
        $name2 = str_replace('.'.$type, '', $filename);
        $iter = 1;
        $filename2 = $filename;
        while(file_exists($directory.$filename2)) {
            $filename2 = $name2 . '(' . ++$iter . ').' .$type;
        }
        return parent::save($file, $filename2, $directory, $chmod);
    }

    public static function is_image(array $file) {
        $is_image = TRUE;
        switch ($file['error']) {
            case UPLOAD_ERR_OK:
                if ($file['type'] != 'image/jpeg' and $file['type'] != 'image/pjpeg' and $file['type'] != 'image/png' and $file['type'] != 'image/x-png')
                    $is_image = FALSE;
                elseif ($file['size'] == 0)
                    $is_image = FALSE;
                break;
            default:
                $is_image = FALSE;
                break;
        }
        return $is_image;
    }

    public static function is_image_correct_or_empty(array $file) {
        return ($file['error'] === UPLOAD_ERR_NO_FILE ? TRUE : self::is_image($file));
    }

    public static function is_image_size_correct(array $file, $width, $height) {
        if (!self::is_image($file)) {
            return FALSE;
        }
        $info = @getimagesize($file['tmp_name']);
        if(!isset($info[0])) {
            return FALSE;
        } else {
            if($info[0] != $width) return FALSE;
            if($info[1] != $height) return FALSE;
        }
        return TRUE;
    }

    public static function is_image_empty_or_size_correct(array $file, $width, $height) {
        if($file['error'] == 4) {
            return TRUE;
        }
        if (!self::is_image($file)) {
            return FALSE;
        }
        $info = @getimagesize($file['tmp_name']);
        if(!isset($info[0])) {
            return FALSE;
        } else {
            if($info[0] != $width) return FALSE;
            if($info[1] != $height) return FALSE;
        }
        return TRUE;
    }

}
