<?php

defined('SYSPATH') or die('No direct script access.');

/**
 * Klasa budująca uri dla różnych obiektów
 *
 * @author Andrzej Skupień
 * @version 1.0
 */
class Route extends Kohana_Route {
    /**
     * Podstawowy route do budowania adresów
     */
    const BASIC = 'front';

    const CONTROLLER = 'controller';
    const ACTION = 'action';
    const USER_FRIENDLY = 'user_friendly';
    const ID = 'id';

    /**
     * zwraca uri dla kategorii z górnego menu na podstawie nazwy kontrolera
     * @param string $controller nazwa controllera
     * @return string uri do kategori
     */
    public static function category($controller) {
	return self::get(self::BASIC)
		->uri(array(self::CONTROLLER => $controller, self::ACTION => ''));
    }

    /**
     * Zwraca uri dla strony na podstawie nazwy kontrolera, strony oraz id do strony
     * @param string $controller nazwa kontrolera
     * @param string $name nazwa docelowej strony
     * @param integer $id id docelowej strony
     * @return uri do strony
     */
    public static function site($controller, $name, $id) {
	return self::get(self::BASIC)
		->uri(array(self::CONTROLLER => $controller,
		    self::ID => $id,
		    self::USER_FRIENDLY => UTF8::user_friendly($name)));
    }
    public static function text($text) {
          return parent::get('action_list')
                ->uri(array(self::CONTROLLER => 'action',
                    'action'=>'list',
                    'year' => $text));
    }
    public static function action_year($year) {
        return self::get('action_list')
                ->uri(array(self::CONTROLLER => 'action',
                    'action'=>'list',
                    'year' => $year));
    }
    public static function action_site($year, $id, $name) {
        return self::get('action')
                ->uri(array(self::CONTROLLER => 'action',
                    'year' => $year,
                    'id' => $id,
                    'name' => UTF8::user_friendly($name)));
    }
    public static function gallery_year($year) {
        return self::get('gallery_list')
                ->uri(array(self::CONTROLLER => 'gallery',
                    'action'=>'list',
                    'year' => $year));
    }
    public static function gallery_site($year, $id, $name) {
        return self::get('gallery')
                ->uri(array(self::CONTROLLER => 'gallery',
                    'year' => $year,
                    'id' => $id,
                    'name' => UTF8::user_friendly($name)));
    }

}

?>
