
<?php

defined('SYSPATH') or die('No direct script access.');

/**
 * Klasa budująca ciąg query
 *
 * @author Andrzej Skupień
 * @version 1.0
 */
class Query {
    /**
     * nazwa pola przechowująca wartość dla Pagination
     */
    const PAGINATION = 'page';
    const SUCCESS = 'success';
    private $values = array();

    /**
     * buduje string query z ustawionych warotści
     * @return string zwraca query w postaci "?key1=value1&key2=value2&(..)"
     */
    public function build() {
	if (empty($this->values)) {
	    return '';
	} else {
	    foreach ($this->values as $key => $value) {
		$query[] = "$key=$value";
	    }
	    return '?' . implode('&', $query);
	}
    }

    /**
     * sortuje pary "klucz=wartość" według kluczy
     */
    public function sort() {
	ksort($this->values);
    }

    /**
     * 	Przepisuje klucze i wartości z wcześniejszego zapytania.
     * 
     * 	Dla klucza przechowującego wartość paginacji, przeprowadzana jest próba
     * przepisania wartości z sesji
     * @param mixed $names nazwa kluczy do przepisania z tablicy $_GET
     */
    public function rewrite_positive($names) {
	$names = (array) $names;
	foreach ($names as $name) {
	    if ($this->is_positive_in_get($name)) {
		$this->values[$name] = $_GET[$name];
	    } elseif ($name == self::PAGINATION) {
		$this->rewrite_page_number();
	    }
	}
    }

    /**
     * próbuje przepisać wartość paginacji z sesji
     */
    private function rewrite_page_number() {
	$key = self::PAGINATION . '_' . Kohana_Request::instance()->controller;
	$session_value = Kohana_Session::instance()->get($key);
	if ($session_value > 1) {
	    $this->values[self::PAGINATION] = $session_value;
	}
    }

    private function is_positive_in_get($name) {
	return isset($_GET[$name]) && $_GET[$name] > 0;
    }

    /**
     * Dodaje nowe wartości do zapytania query
     * @param string $key klucz warotści $_GET
     * @param string $value wartośc $_GET
     */
    public function add($key, $value) {
	$this->values[$key] = $value;
    }

}

?>
