<?php

defined('SYSPATH') or die('No direct script access.');

class Model_User extends Model_Auth_Users {

    /**
     * @var array $_skipped_users User roles that shall not be avaiable through
     * multiple object queries such as count(), find_all()
     */
    protected $_skipped_users = array('admin', 'atech');
    protected $_table_name = 'auth_users';
    protected $_sorting = array('username' => 'asc', 'id' => 'asc');

    public function save() {
        if (isset($this->_changed['password'])) {
            if (empty($this->_object['password'])) {
                unset($this->_object['password']);
                unset($this->_changed['password']);
            } else {
                $this->_object['password'] = simpleauth::instance()->hash($this->_object['password']);
            }
        }
        if (!$this->is_new()) {
            return parent::save();
        } else {
            return $this->create();
        }
    }

    /**
     * Creates new user; checks whether apropriate fields are unique in the DB
     * @param string $second name of second unique field to verify
     * @return  boolean
     */
    public function create($second = FALSE) {

        $config = simpleauth::instance()->get_config();
        $user_exist = $this->exists($config['unique']);
        if ($second) {
            $user_exist |= $user->exists($config['unique_second']);
        }

        if ($user_exist) {
            return FALSE;
        }

        if (isset($this->active_to) AND !strtotime($this->active_to)) {
            $this->active_to = '';
        }

        return parent::save();
    }

    protected function start_query() {
        $roles = simpleauth::instance()->get_roles();
        $query = $roles->sql_user_is_not($this->_skipped_users, $this);
        return $query;
    }

    public function get_range($from, $number, $as_array = TRUE) {
        $items = $this->start_query()->offset($from)->limit($number)->find_all();
        if ($as_array) {
            $items = $items->as_array();
        }
        return $items;
    }

    public function count_all() {
        $this->start_query();
        return parent::count_all();
    }

    public function get_count_all() {
        return $this->count_all();
    }

    public function get_id() {
        return $this->pk();
    }

    public function delete($id = NULL) {
        $model = $id === NULL ? $this : $this->find($id);
        // BŁĄD !! if ($model->has_role($this->_skipped_users)) {
        if (simpleauth::instance()->has_role($this->_skipped_users, $model->id)) {
            return FALSE;
        }
        return parent::delete($id);
    }

}

?>
