<?php

defined('SYSPATH') or die('No direct script access.');

abstract class Model_Text extends ORM_Extended {

    protected $_table_name = 'content';
    protected $_has_one = array(
        'repository' => array('foreign_key' => 'element_id'),
        'gallery' => array('foreign_key' => 'element_id')
    );
    protected $_sorting = array('content.sort' => 'asc');
    protected $_original = array();
    protected static $KEEP_ORIGINAL_VALUES = array('sort');
    protected $kind = NULL;

    public function get_kind() {
        return ORM::factory('Content_Kind')->where('id','=',$this->kind_id)->find()->name;
    }

    public function change_sort($new_sort) {
        $this->sort = $new_sort;
        $this->save();
    }

    public function get_first() {
        return $this->text_filter()->where('id_parent', '=', (int) @$_GET['parent'])->find();
    }

    public function get_random_row() {
        return $this->text_filter()->order_by(DB::expr('RAND()'))->limit(1)->find();
    }

    public function get_random_rows($number_of_rows) {
        return $this->text_filter()->order_by(DB::expr('RAND()'))->limit($number_of_rows)->find_all();
    }

    public function get_max_sort() {
        return $this->text_filter()->where('content.id_parent', '=', (int) @$_GET['parent'])->count_all();
    }

    public function get_range($from, $number) {
        return $this->text_filter()->where('content.id_parent', '=', (int) @$_GET['parent'])->offset($from)->limit($number)->find_all();
    }

    protected function text_filter() {
        return $this->where('content.kind_id', '=', $this->kind_id)->where('content.language_id', '=', Kohana_Session::instance()->get('application_language'));
    }

    public function get_all() {
        return $this->get_range(0, $this->get_count_all());
    }

    public function get_count_all() {
        return $this->get_max_sort();
    }

    public function before_delete() {
        $sub = ORM::factory('Content')->where('id_parent', '=', $this->id)->find_all();
        foreach ($sub as $subarticle) {
            $subarticle->delete();
        }
        $this->update_sort($this->pk());
        $this->delete_repository();
        $this->delete_gallery();
    }

    public function __get($path) {
        if ($path == 'repository') {
            $repo_kind = (isset($this->repo_kind) ? $this->repo_kind : $this->kind);
            $repo_kind_id = ORM::factory('Repository_Kind')->where('name', '=', $repo_kind)->find()->pk();
            return ORM::factory('Repository', array('kind_id' => $repo_kind_id, 'element_id' => $this->pk()));
        } elseif ($path == 'kind_id') {
            return $this->get_content_kind_id();
        }
        return parent::__get($path);
    }

    public function __set($column, $value) {
        if (in_array($column, self::$KEEP_ORIGINAL_VALUES)) {
            if (array_key_exists($column, $this->_object) && !isset($this->_original[$column])) {
                // if coumn exists and we don't have any original value stored yet
                $this->_original[$column] = parent::__get($column);
            }
        }
        parent::__set($column, $value);
    }

    public function save() {
        $sort = $this->sort;
        $new = $this->is_new();
        if (!$new && isset($this->_changed['sort'])) {
            // Primary key isn't empty and hasn't been changed so do an update
            // Moreover and sort field has been changed

            if ($this->sort < $this->_original['sort']) {
                $this->change_sort_in_range($this->sort, $this->_original['sort'], 1);
            } else {
                $this->change_sort_in_range($this->_original['sort'], $this->sort, -1);
            }
        }
        if ($new) {
            $this->date_added = date('Y-m-d H:i:s');
            if (!isset($this->kind_id)) {
                $this->kind_id = $this->get_content_kind_id();
            }
            if (!isset($this->sort)) {
                $this->sort = ($this->get_max_sort() + 1);
            }
            if (!isset($this->id_parent)) {
                $this->id_parent = (int) @$_GET['parent'];
            }
        }
        $this->language_id = Kohana_Session::instance()->get('application_language');
        parent::save();
        if ($new) {
            $this->create_repository();
            $this->create_gallery();
        }
        return $this;
    }

    private function update_sort($id) {
        $results = $this->get_sort_values_to_update($id);
        foreach ($results as $result) {
            $this->change_sort_in_range($result['sort']);
        }
    }

    private function get_sort_values_to_update($id) {
        if ($id === null) {
            $sort = array(array('sort' => $this->sort));
        } else {
            $sort = $this->_db->query(Database::SELECT, $this->build_get_sort_query($id), FALSE);
        }
        return $sort;
    }

    private function build_get_sort_query($ids) {
        if (!is_array($ids)) {
            $ids = array($ids);
        }
        $tbl_name = $this->_db->table_prefix() . 'content';
        if (!isset($this->id_parent)) {
            $this->id_parent = (int) @$_GET['parent'];
        }
        $query_str = 'SELECT sort FROM ' . $tbl_name . ' WHERE id in(' . implode(',', $ids) . ') and kind_id = ' . $this->kind_id . ' AND id_parent = ' . $this->id_parent . ' AND language_id = ' . Kohana_Session::instance()->get('application_language');
        return $query_str;
    }

    /**
     * Function which changes value of 'sort' field by a given value for all items that
     * original value is in range < sort_low_limit, sort_high_limit > (inclusive!)
     * @param <type> $sort_low_limit lower bound for sort values to be updated
     * @param <type> $sort_high_limit upper bound for sort values to be updated, default no upper bound
     * @param <type> $change defined by how the value will be changed, default - 1
     */
    private function change_sort_in_range($sort_low_limit, $sort_high_limit = null, $change = -1) {
        $change_str = '';
        if ($change >= 0)
            $change_str = '+ ';
        $change_str .= (string) $change;
        $query = 'UPDATE ' . $this->_db->table_prefix() . $this->_table_name . ' SET sort = sort ' . $change_str .' WHERE kind_id = ' . $this->kind_id . ' AND id_parent=' . $this->id_parent . ' AND sort >= ' . $sort_low_limit . ' AND language_id = ' . Kohana_Session::instance()->get('application_language');

        if (!is_null($sort_high_limit)) {
            $query .= ' AND sort <= ' . $sort_high_limit;
        }
        $this->_db->query(Database::UPDATE, $query, FALSE);

    //aktualizacja numerowania kategorii po zmianie sortowania
        if (is_null($sort_high_limit)) {
            $query = 'SELECT sort FROM '. $this->_db->table_prefix() . $this->_table_name .' WHERE kind_id = ' . $this->kind_id . ' AND id_parent=' . $this->id_parent . ' AND sort >= ' . $sort_low_limit . ' AND language_id = ' . Kohana_Session::instance()->get('application_language');
             $result = $this->_db->query(Database::SELECT, $query, FALSE);
             $sort_high_limit =  $result->count()+$sort_low_limit;
        }
    }

    protected function create_repository() { }

    protected function delete_repository() { }

    protected function create_gallery() { }

    protected function delete_gallery() { }


    public function get_content_kind_id() {
        if ($this->is_new()) {
            return ORM::factory('Content_Kind')->where('name', '=', $this->kind)->find()->id;
        }
        return parent::__get('kind_id');
    }

    public function get_owner_model() {
        $modelname = $this->content_kind->name;
        if ($modelname != $this->kind) {
            $model = ORM::factory($modelname, $this->pk());
            return $model->get_owner_model();
        } else {
            return NULL;
        }
    }

}

?>
