<?php

defined('SYSPATH') or die('No direct script access.');

class Model_Site_Middle extends Model_Site {

    protected $_table_name = 'content_sites_middle';
    protected $_extends = array(
        'content' => array('table_name' => 'content', 'foreign_key' => 'content_id')
    );
    protected $_sorting = array('content.sort' => 'asc');
    protected $kind = 'Site_Middle';
    protected $kind_id = 4;

    protected $translated = array('name', 'meta_title', 'meta_description', 'meta_keywords', 'body');

    protected function create_gallery() {
        $repo = ORM::factory('Gallery');
        $repo->gallery_kind = ORM::factory('Gallery_Kind')->where('name', '=', $this->kind)->find();
        $repo->element_id = $this->content_id;
        $repo->save();
    }

    protected function delete_gallery() {
        $this->gallery->delete();
    }

}

?>
